/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.util;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;

public final class AsyncUtils {
    public static final CompletableFuture<?> EMPTY = CompletableFuture.completedFuture(null);

    public static <T> CompletableFuture<T> empty() {
        return EMPTY;
    }

    public static <T> CompletableFuture<T> failureOf(Throwable throwable) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(throwable);
        return future;
    }

    public static CompletableFuture<?> allOf(Collection<CompletableFuture<?>> futures) {
        if (futures.isEmpty()) {
            return AsyncUtils.empty();
        }
        if (futures.size() == 1) {
            return futures.iterator().next();
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    private AsyncUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

