/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.util;

import org.jetbrains.annotations.Contract;

public final class ConditionUtils {
    @Contract(value="false, _ -> fail")
    public static void is(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    @Contract(value="true, _ -> fail")
    public static void not(boolean expression, String message) {
        if (expression) {
            throw new IllegalArgumentException(message);
        }
    }

    @Contract(value="false, _, _ -> fail")
    public static void is(boolean expression, String message, Object ... args) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(message, args));
        }
    }

    @Contract(value="false, _, _ -> fail")
    public static void is(boolean expression, String message, Object arg) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(message, arg));
        }
    }

    @Contract(value="null, _ -> fail")
    public static void notNull(Object argument, String name) {
        if (argument == null) {
            throw new IllegalArgumentException(name + " may not be null");
        }
    }

    @Contract(value="null, _ -> fail")
    public static void notEmpty(CharSequence argument, String name) {
        ConditionUtils.notNull(argument, name);
        if (argument.length() == 0) {
            throw new IllegalArgumentException(name + " may not be empty");
        }
    }

    private ConditionUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

