/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.util;

import org.jetbrains.annotations.Nullable;

public interface EquivalentConverter<T> {
    public Object getGeneric(T var1);

    public T getSpecific(Object var1);

    public Class<T> getSpecificType();

    public static class EnumConverter<T extends Enum<T>>
    implements EquivalentConverter<T> {
        private Class<? extends Enum> genericType;
        private Class<T> specificType;

        public EnumConverter(@Nullable Class<? extends Enum> genericType, @Nullable Class<T> specificType) {
            this.genericType = genericType;
            this.specificType = specificType;
        }

        @Override
        public T getSpecific(@Nullable Object generic) {
            if (generic == null) {
                return this.getDefaultSpecific();
            }
            return Enum.valueOf(this.specificType, ((Enum)generic).name());
        }

        @Override
        public Object getGeneric(@Nullable T specific) {
            if (specific == null) {
                return this.getDefaultGeneric();
            }
            return Enum.valueOf(this.genericType, ((Enum)specific).name());
        }

        @Nullable
        public T getDefaultSpecific() {
            return null;
        }

        @Nullable
        public Object getDefaultGeneric() {
            return null;
        }

        void setGenericType(Class<? extends Enum> genericType) {
            this.genericType = genericType;
        }

        public Class<? extends Enum> getGenericType() {
            return this.genericType;
        }

        @Override
        public Class<T> getSpecificType() {
            return this.specificType;
        }
    }
}

