/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.util;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Utility {
    private static final Map<Class<?>, Class<?>> PRIMITIVES_TO_WRAPPERS = new ConcurrentHashMap();

    public static <T> Constructor<T> getConstructor(Class<T> parentClass, Class<?> ... parameterTypes) {
        try {
            return parentClass.getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public static <T> String joinToString(T[] array) {
        return array == null ? "null" : Utility.joinToString(Arrays.asList(array));
    }

    public static <T> String joinToString(T[] array, String delimiter) {
        return array == null ? "null" : Utility.joinToString(Arrays.asList(array), delimiter);
    }

    public static <T> String joinToString(Iterable<T> array) {
        return array == null ? "null" : Utility.joinToString(array, ", ");
    }

    public static <T> String joinToString(Iterable<T> array, String delimiter) {
        return Utility.join(array, delimiter, object -> object == null ? "" : object.toString());
    }

    public static <T> String join(Iterable<T> array, String delimiter, Stringer<T> stringer) {
        Iterator<T> it = array.iterator();
        StringBuilder message = new StringBuilder();
        while (it.hasNext()) {
            T next = it.next();
            if (next == null) continue;
            message.append(stringer.toString(next)).append(it.hasNext() ? delimiter : "");
        }
        return message.toString();
    }

    public static <T> List<Field> getAllFields(Class clazz) {
        ArrayList classes = new ArrayList();
        while (clazz != Object.class) {
            classes.add(clazz);
            clazz = clazz.getSuperclass();
        }
        Collections.reverse(classes);
        return classes.stream().map(Class::getDeclaredFields).flatMap(Stream::of).collect(Collectors.toList());
    }

    public static Set<Class<?>> getSuperClasses(Class<?> type) {
        HashSet superclasses = new HashSet();
        for (Class<?> superclass = type; superclass != null && superclass != Object.class; superclass = superclass.getSuperclass()) {
            superclasses.add(superclass);
        }
        return superclasses;
    }

    public static Collection<Class<?>> getSuperAndInterfaces(Class<?> type) {
        Set<Class<?>> superclasses = Utility.getSuperClasses(type);
        HashSet result = new HashSet(superclasses);
        while (superclasses.size() > 0) {
            ArrayList clone = new ArrayList(superclasses);
            superclasses.clear();
            for (Class clazz : clone) {
                result.add(clazz);
                Class<?>[] interfaces = clazz.getInterfaces();
                if (interfaces.length <= 0) continue;
                superclasses.addAll(Arrays.asList(interfaces));
            }
        }
        return result;
    }

    public static <T> Class<T> wrapPrimitive(Class<T> c) {
        return c.isPrimitive() ? PRIMITIVES_TO_WRAPPERS.get(c) : c;
    }

    public static String getJVMName(Class clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isArray()) {
            return clazz.getName().replace('.', '/');
        }
        if (clazz == Boolean.TYPE) {
            return "Z";
        }
        if (clazz == Byte.TYPE) {
            return "B";
        }
        if (clazz == Short.TYPE) {
            return "S";
        }
        if (clazz == Integer.TYPE) {
            return "I";
        }
        if (clazz == Long.TYPE) {
            return "J";
        }
        if (clazz == Float.TYPE) {
            return "F";
        }
        if (clazz == Double.TYPE) {
            return "D";
        }
        if (clazz == Character.TYPE) {
            return "C";
        }
        return "L" + clazz.getName().replace('.', '/') + ";";
    }

    public static Class<?> getArrayClassFromType(Class<?> clazz) {
        Objects.requireNonNull(clazz);
        try {
            return Class.forName("[" + Utility.getJVMName(clazz).replace('/', '.'));
        }
        catch (ClassNotFoundException ex) {
            throw new NoClassDefFoundError(ex.getMessage());
        }
    }

    public static Type[] getGenericTypes(Field field) {
        Type type = field.getGenericType();
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments();
        }
        return null;
    }

    public static boolean isParametersEquals(Type[] parametersA, Type[] parametersB) {
        boolean equal = true;
        if (parametersA.length != parametersB.length) {
            return false;
        }
        for (int i = 0; i < parametersA.length; ++i) {
            Class typeB;
            Class typeA = parametersA[i];
            if (typeA instanceof Class) {
                typeA = Utility.wrapPrimitive(typeA);
            }
            if ((typeB = parametersB[i]) instanceof Class) {
                typeB = Utility.wrapPrimitive(typeB);
            }
            if (typeA instanceof Class && typeB instanceof Class) {
                Class classB = typeB;
                Class classA = typeA;
                if (classB.isAssignableFrom(classA)) continue;
                equal = false;
                break;
            }
            if (Objects.equals(typeA, typeB)) continue;
            equal = false;
            break;
        }
        return equal;
    }

    public static <I, R> R[] toArrayType(I[] originalArray, Class<R> resultType, Function<I, R> transfer) {
        Object[] result = (Object[])Array.newInstance(resultType, originalArray.length);
        for (int i = 0; i < result.length; ++i) {
            result[i] = transfer.apply(originalArray[i]);
        }
        return result;
    }

    public static <T> void twice(Collection<T> collection, BiConsumer<T, T> consumer) {
        for (T t1 : collection) {
            for (T t2 : collection) {
                consumer.accept(t1, t2);
            }
        }
    }

    static {
        PRIMITIVES_TO_WRAPPERS.put(Boolean.TYPE, Boolean.class);
        PRIMITIVES_TO_WRAPPERS.put(Byte.TYPE, Byte.class);
        PRIMITIVES_TO_WRAPPERS.put(Character.TYPE, Character.class);
        PRIMITIVES_TO_WRAPPERS.put(Double.TYPE, Double.class);
        PRIMITIVES_TO_WRAPPERS.put(Float.TYPE, Float.class);
        PRIMITIVES_TO_WRAPPERS.put(Integer.TYPE, Integer.class);
        PRIMITIVES_TO_WRAPPERS.put(Long.TYPE, Long.class);
        PRIMITIVES_TO_WRAPPERS.put(Short.TYPE, Short.class);
        PRIMITIVES_TO_WRAPPERS.put(Void.TYPE, Void.class);
    }

    public static interface Stringer<T> {
        public String toString(T var1);
    }
}

