/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.util.collection;

import io.fairyproject.util.collection.AbstractConverted;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public abstract class ConvertedCollection<VInner, VOuter>
extends AbstractConverted<VInner, VOuter>
implements Collection<VOuter> {
    private Collection<VInner> inner;

    public ConvertedCollection(Collection<VInner> inner) {
        this.inner = inner;
    }

    @Override
    public boolean add(VOuter e) {
        return this.inner.add(this.toInner(e));
    }

    @Override
    public boolean addAll(Collection<? extends VOuter> c) {
        boolean modified = false;
        for (VOuter outer : c) {
            modified |= this.add(outer);
        }
        return modified;
    }

    @Override
    public void clear() {
        this.inner.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.inner.contains(this.toInner(o));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object outer : c) {
            if (this.contains(outer)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.inner.isEmpty();
    }

    @Override
    public Iterator<VOuter> iterator() {
        final Iterator<VInner> iterator = this.inner.iterator();
        return new Iterator<VOuter>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public VOuter next() {
                return ConvertedCollection.this.getOuterConverter().apply(iterator.next());
            }
        };
    }

    @Override
    public boolean remove(Object o) {
        return this.inner.remove(this.toInner(o));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object outer : c) {
            modified |= this.remove(outer);
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        ArrayList innerCopy = new ArrayList();
        for (Object outer : c) {
            innerCopy.add(this.toInner(outer));
        }
        return this.inner.retainAll(innerCopy);
    }

    @Override
    public int size() {
        return this.inner.size();
    }

    @Override
    public Object[] toArray() {
        Object[] array = this.inner.toArray();
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.toOuter(array[i]);
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Object[] array = a;
        int index = 0;
        if (array.length < this.size()) {
            array = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
        }
        for (VInner innerValue : this.inner) {
            array[index++] = this.toOuter(innerValue);
        }
        return array;
    }
}

