/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.util.collection;

import io.fairyproject.util.ConditionUtils;
import io.fairyproject.util.collection.TransformedIterator;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class TransformedCollection<F, T>
extends AbstractCollection<T> {
    final Collection<F> fromCollection;
    final Function<F, T> function;

    @Override
    public void clear() {
        this.fromCollection.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.fromCollection.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return new TransformedIterator<F, T>(this.fromCollection.iterator(), this.function);
    }

    @Override
    public Spliterator<T> spliterator() {
        return TransformedCollection.map(this.fromCollection.spliterator(), this.function);
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        ConditionUtils.notNull(action, "action");
        this.fromCollection.forEach(f -> action.accept((T)this.function.apply(f)));
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        ConditionUtils.notNull(filter, "filter");
        return this.fromCollection.removeIf((? super E element) -> filter.test((T)this.function.apply(element)));
    }

    @Override
    public int size() {
        return this.fromCollection.size();
    }

    static <F, T> Spliterator<T> map(final Spliterator<F> fromSpliterator, final Function<? super F, ? extends T> function) {
        ConditionUtils.notNull(fromSpliterator, "fromSpliterator");
        ConditionUtils.notNull(function, "function");
        return new Spliterator<T>(){

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                return fromSpliterator.tryAdvance(fromElement -> action.accept((Object)function.apply(fromElement)));
            }

            @Override
            public void forEachRemaining(Consumer<? super T> action) {
                fromSpliterator.forEachRemaining(fromElement -> action.accept((Object)function.apply(fromElement)));
            }

            @Override
            public Spliterator<T> trySplit() {
                Spliterator fromSplit = fromSpliterator.trySplit();
                return fromSplit != null ? TransformedCollection.map(fromSplit, function) : null;
            }

            @Override
            public long estimateSize() {
                return fromSpliterator.estimateSize();
            }

            @Override
            public int characteristics() {
                return fromSpliterator.characteristics() & 0xFFFFFEFA;
            }
        };
    }

    public TransformedCollection(Collection<F> fromCollection, Function<F, T> function) {
        this.fromCollection = fromCollection;
        this.function = function;
    }
}

