/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.util.entry;

import io.fairyproject.util.entry.Entry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;

public class EntryArrayList<K, V>
extends ArrayList<Entry<K, V>> {
    public void add(K k, V v) {
        this.add(new Entry<K, V>(k, v));
    }

    public boolean remove(K k, V v) {
        return this.remove(new Entry<K, V>(k, v));
    }

    public boolean containsKey(K k) {
        for (Entry entry : this) {
            if (entry.getKey() != k) continue;
            return true;
        }
        return false;
    }

    public V get(K k) {
        for (Entry entry : this) {
            if (entry.getKey() != k) continue;
            return entry.getValue();
        }
        return null;
    }

    public List<K> keys() {
        return this.stream().map(Entry::getKey).collect(Collectors.toList());
    }

    public List<V> values() {
        return this.stream().map(Entry::getValue).collect(Collectors.toList());
    }

    public boolean removeIf(BiPredicate<K, V> filter) {
        return this.removeIf((? super E entry) -> filter.test(entry.getKey(), entry.getValue()));
    }

    public void forEach(BiConsumer<K, V> consumer) {
        this.forEach((? super E entry) -> consumer.accept(entry.getKey(), entry.getValue()));
    }
}

