/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.util.exceptionally;

import io.fairyproject.util.exceptionally.CheckedException;
import io.fairyproject.util.exceptionally.SneakyThrowUtil;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;

@FunctionalInterface
public interface ThrowingBiFunction<T1, T2, R, E extends Exception> {
    public R apply(T1 var1, T2 var2) throws E;

    public static <T1, T2, R> BiFunction<T1, T2, R> unchecked(ThrowingBiFunction<? super T1, ? super T2, ? extends R, ?> function) {
        Objects.requireNonNull(function);
        return (arg1, arg2) -> {
            try {
                return function.apply(arg1, arg2);
            }
            catch (Exception e) {
                throw new CheckedException(e);
            }
        };
    }

    public static <T1, T2, R> BiFunction<T1, T2, R> sneaky(ThrowingBiFunction<? super T1, ? super T2, ? extends R, ?> function) {
        Objects.requireNonNull(function);
        return (t1, t2) -> {
            try {
                return function.apply(t1, t2);
            }
            catch (Exception ex) {
                return SneakyThrowUtil.sneakyThrow(ex);
            }
        };
    }

    public static <T1, T2, R> BiFunction<T1, T2, Optional<R>> optional(ThrowingBiFunction<? super T1, ? super T2, ? extends R, ?> function) {
        Objects.requireNonNull(function);
        return (arg1, arg2) -> {
            try {
                return Optional.ofNullable(function.apply(arg1, arg2));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        };
    }
}

