/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.util.exceptionally;

import io.fairyproject.util.exceptionally.CheckedException;
import io.fairyproject.util.exceptionally.SneakyThrowUtil;
import java.util.Objects;
import java.util.function.BiPredicate;

@FunctionalInterface
public interface ThrowingBiPredicate<T, U, E extends Exception> {
    public boolean test(T var1, U var2) throws E;

    public static <T, U> BiPredicate<T, U> unchecked(ThrowingBiPredicate<? super T, ? super U, ?> predicate) {
        Objects.requireNonNull(predicate);
        return (arg1, arg2) -> {
            try {
                return predicate.test(arg1, arg2);
            }
            catch (Exception e) {
                throw new CheckedException(e);
            }
        };
    }

    public static <T, U> BiPredicate<T, U> sneaky(ThrowingBiPredicate<? super T, ? super U, ?> predicate) {
        Objects.requireNonNull(predicate);
        return (t, u) -> {
            try {
                return predicate.test(t, u);
            }
            catch (Exception e) {
                return (Boolean)SneakyThrowUtil.sneakyThrow(e);
            }
        };
    }
}

