/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.util.exceptionally;

import io.fairyproject.util.exceptionally.CheckedException;
import io.fairyproject.util.exceptionally.SneakyThrowUtil;
import io.fairyproject.util.exceptionally.ThrowingFunction;
import java.util.Objects;
import java.util.function.UnaryOperator;

@FunctionalInterface
public interface ThrowingUnaryOperator<T, E extends Exception>
extends ThrowingFunction<T, T, E> {
    public static <T> UnaryOperator<T> unchecked(ThrowingUnaryOperator<T, ?> operator) {
        Objects.requireNonNull(operator);
        return t -> {
            try {
                return operator.apply(t);
            }
            catch (Exception e) {
                throw new CheckedException(e);
            }
        };
    }

    public static <T> UnaryOperator<T> sneaky(ThrowingUnaryOperator<T, ?> operator) {
        Objects.requireNonNull(operator);
        return t -> {
            try {
                return operator.apply(t);
            }
            catch (Exception e) {
                return SneakyThrowUtil.sneakyThrow(e);
            }
        };
    }
}

