/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.util.random;

import io.fairyproject.util.random.WeightedItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public final class WeightedRandom {
    private static final Random DEFAULT_RANDOM = new Random();

    public static int getTotalWeight(Collection<? extends WeightedItem> collection) {
        return collection.stream().map(WeightedItem::getWeight).reduce(0, Integer::sum);
    }

    public static <T extends WeightedItem> T getRandomItem(List<? extends T> collection, Random random) {
        return WeightedRandom.getItemFor(collection, random.nextInt(WeightedRandom.getTotalWeight(collection)));
    }

    private static <T extends WeightedItem> T getItemFor(List<T> collection, int value) {
        WeightedItem item;
        Iterator<T> iterator = collection.iterator();
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while ((value -= (item = (WeightedItem)iterator.next()).getWeight()) >= 0);
        return (T)item;
    }

    public static <T extends WeightedItem> T getRandomItem(Collection<? extends T> collection, Random random) {
        return WeightedRandom.getRandomItem(new ArrayList<T>(collection), random);
    }

    public static <T extends WeightedItem> T getRandomItem(List<? extends T> collection) {
        return WeightedRandom.getRandomItem(collection, DEFAULT_RANDOM);
    }

    public static <T extends WeightedItem> T getRandomItem(Collection<? extends T> collection) {
        return WeightedRandom.getRandomItem(collection, DEFAULT_RANDOM);
    }

    private WeightedRandom() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

