/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.gui.slot;

import io.fairyproject.bukkit.gui.Gui;
import io.fairyproject.bukkit.gui.pane.PaginatedPane;
import io.fairyproject.bukkit.gui.slot.GuiSlot;
import io.fairyproject.libs.xseries.XSound;
import java.util.function.Consumer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModPageGuiSlot
implements GuiSlot {
    private final PaginatedPane pane;
    private final ItemStack itemStack;
    private final int mod;
    @Nullable
    private final Consumer<InventoryClickEvent> clickCallback;

    @Override
    public ItemStack getItemStack(@NotNull Player player, @NotNull Gui gui) {
        return this.itemStack;
    }

    @Override
    public void onInventoryClick(@NotNull InventoryClickEvent event, @NotNull Gui gui) {
        Player player = (Player)event.getWhoClicked();
        if (this.pane.getPage() + this.mod < 0) {
            this.sendCannotPrevious(player);
            return;
        }
        if (this.pane.getPage() + this.mod >= this.pane.getMaxPage()) {
            this.sendCannotNext(player);
            return;
        }
        this.pane.setPage(this.pane.getPage() + this.mod);
        gui.update(player);
        XSound.UI_BUTTON_CLICK.play((Entity)player);
        if (this.clickCallback != null) {
            this.clickCallback.accept(event);
        }
    }

    public void sendCannotPrevious(Player player) {
        player.sendMessage("\u00a7cYou cannot go back any further.");
        XSound.ENTITY_VILLAGER_NO.play((Entity)player);
    }

    public void sendCannotNext(Player player) {
        player.sendMessage("\u00a7cYou cannot go forward any further.");
        XSound.ENTITY_VILLAGER_NO.play((Entity)player);
    }

    public ModPageGuiSlot(PaginatedPane pane, ItemStack itemStack, int mod, @Nullable Consumer<InventoryClickEvent> clickCallback) {
        this.pane = pane;
        this.itemStack = itemStack;
        this.mod = mod;
        this.clickCallback = clickCallback;
    }
}

