/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.listener.asm;

import com.google.common.base.Preconditions;
import io.fairyproject.bukkit.listener.FilteredEventList;
import io.fairyproject.bukkit.listener.annotation.PlayerSearchAttribute;
import io.fairyproject.bukkit.player.PlayerEventRecognizer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import lombok.NonNull;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.Listener;
import org.bukkit.plugin.EventExecutor;

public class StaticMethodHandleEventExecutor
implements EventExecutor {
    private final boolean ignoredFilters;
    private final FilteredEventList eventList;
    private final Class<? extends Event> eventClass;
    private final Method handle;
    private final Class<? extends PlayerEventRecognizer.Attribute<?>>[] attributes;

    public StaticMethodHandleEventExecutor(@NonNull Class<? extends Event> eventClass, @NonNull Method m, boolean ignoredFilters, FilteredEventList eventList) {
        if (eventClass == null) {
            throw new NullPointerException("eventClass is marked non-null but is null");
        }
        if (m == null) {
            throw new NullPointerException("m is marked non-null but is null");
        }
        Preconditions.checkArgument((boolean)Modifier.isStatic(m.getModifiers()), (String)"Not a static method: %s", (Object)m);
        this.eventClass = eventClass;
        this.ignoredFilters = ignoredFilters;
        this.eventList = eventList;
        m.setAccessible(true);
        this.handle = m;
        PlayerSearchAttribute annotation = m.getAnnotation(PlayerSearchAttribute.class);
        this.attributes = annotation != null ? annotation.value() : new Class[0];
    }

    public void execute(@NonNull Listener listener, @NonNull Event event) throws EventException {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (this.eventClass.isInstance(event) && (this.ignoredFilters || this.eventList.check(event, this.attributes))) {
            this.handle.invoke((Object)event, new Object[0]);
        }
    }
}

