/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.mc.operator;

import io.fairyproject.bukkit.mc.PaperMCGameProfile;
import io.fairyproject.bukkit.mc.operator.BukkitMCPlayerOperator;
import io.fairyproject.bukkit.nms.BukkitNMSManager;
import io.fairyproject.bukkit.reflection.resolver.FieldResolver;
import io.fairyproject.bukkit.reflection.resolver.ResolverQuery;
import io.fairyproject.container.PreInitialize;
import io.fairyproject.libs.kyori.adventure.text.Component;
import io.fairyproject.mc.MCAdventure;
import io.fairyproject.mc.MCGameProfile;
import io.fairyproject.mc.MCPlayer;
import io.fairyproject.util.AccessUtil;
import io.fairyproject.util.exceptionally.ThrowingSupplier;
import io.fairyproject.util.filter.FilterUnit;
import io.netty.channel.Channel;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.bukkit.entity.Player;

public class BukkitMCPlayerOperatorImpl
implements BukkitMCPlayerOperator {
    private final BukkitNMSManager nmsManager;
    private Function<Player, Integer> getPing;
    private Function<Player, Component> getDisplayName;
    private BiConsumer<MCPlayer, Component> setDisplayName;
    private Function<Player, MCGameProfile> getGameProfile;
    private Method getHandle;
    private Field playerConnection;
    private Field networkManager;
    private Method profile;
    private Field ping;
    private Field channel;

    public BukkitMCPlayerOperatorImpl(BukkitNMSManager nmsManager) {
        this.nmsManager = nmsManager;
    }

    @PreInitialize
    public void onPreInitialize() {
        try {
            this.getPing = this.setupGetPing();
            this.getGameProfile = this.setupGetGameProfile();
            this.getDisplayName = this.setupGetDisplayName();
            this.setDisplayName = this.setupSetDisplayName();
            this.setupGetChannel();
        }
        catch (Throwable e) {
            throw new IllegalStateException("Failed to initialize BukkitMCPlayerOperator.", e);
        }
    }

    private BiConsumer<MCPlayer, Component> setupSetDisplayName() {
        BiConsumer<MCPlayer, Component> setDisplayName = FilterUnit.create().add((player, component) -> player.as(Player.class).displayName(component), FilterUnit.test(t -> Player.class.getMethod("displayName", Component.class), NoSuchMethodException.class)).add((player, component) -> player.as(Player.class).setDisplayName(MCAdventure.asLegacyString(component, player.getLocale()))).find().orElseThrow(() -> new IllegalStateException("No valid set display name can be found."));
        return setDisplayName;
    }

    private Function<Player, Component> setupGetDisplayName() {
        Function<Player, Component> getDisplayName = FilterUnit.create().add(player -> player.displayName(), FilterUnit.test(t -> Player.class.getMethod("displayName", new Class[0]), NoSuchMethodException.class)).add(player -> MCAdventure.LEGACY.deserialize(player.getDisplayName())).find().orElseThrow(() -> new IllegalStateException("No valid get display name can be found."));
        return getDisplayName;
    }

    private Function<Player, MCGameProfile> setupGetGameProfile() {
        Function<Player, MCGameProfile> getGameProfile = FilterUnit.create().add(player -> new PaperMCGameProfile(player.getPlayerProfile()), FilterUnit.test(t -> Class.forName("com.destroystokyo.paper.profile.PlayerProfile"), ClassNotFoundException.class)).add(player -> ThrowingSupplier.sneaky(() -> MCGameProfile.from(this.profile.invoke(player, new Object[0]))).get()).find().orElseThrow(() -> new IllegalStateException("No valid get game profile can be found."));
        return getGameProfile;
    }

    private Function<Player, Integer> setupGetPing() {
        Function<Player, Integer> getPing = FilterUnit.create().add(player -> player.getPing(), FilterUnit.test(t -> Player.class.getMethod("getPing", new Class[0]), NoSuchMethodException.class)).add(player -> ThrowingSupplier.sneaky(() -> this.ping.getInt(this.getHandle.invoke(player, new Object[0]))).get()).find().orElseThrow(() -> new IllegalStateException("No valid get ping can be found."));
        return getPing;
    }

    private void setupGetChannel() throws ReflectiveOperationException {
        Field ping;
        Class craftPlayerClass = this.nmsManager.getObcClassResolver().resolve("entity.CraftPlayer");
        Class entityPlayerClass = this.nmsManager.getNmsClassResolver().resolve("server.level.EntityPlayer", "EntityPlayer");
        Class playerConnectionClass = this.nmsManager.getNmsClassResolver().resolve("server.network.PlayerConnection", "PlayerConnection");
        Class networkManagerClass = this.nmsManager.getNmsClassResolver().resolve("network.NetworkManager", "NetworkManager");
        this.getHandle = craftPlayerClass.getDeclaredMethod("getHandle", new Class[0]);
        this.playerConnection = new FieldResolver(entityPlayerClass).resolveByFirstType(playerConnectionClass);
        this.networkManager = new FieldResolver(playerConnectionClass).resolve(ResolverQuery.builder().withSupertypes(networkManagerClass, 0).build());
        this.profile = craftPlayerClass.getDeclaredMethod("getProfile", new Class[0]);
        try {
            ping = entityPlayerClass.getDeclaredField("ping");
            AccessUtil.setAccessible(ping);
        }
        catch (Throwable throwable) {
            ping = null;
        }
        this.ping = ping;
        this.channel = new FieldResolver(networkManagerClass).resolveByFirstType(Channel.class);
        AccessUtil.setAccessible(this.getHandle);
        AccessUtil.setAccessible(this.playerConnection);
        AccessUtil.setAccessible(this.networkManager);
        AccessUtil.setAccessible(this.profile);
        AccessUtil.setAccessible(this.channel);
    }

    @Override
    public int getPing(Player player) {
        return this.getPing.apply(player);
    }

    @Override
    public MCGameProfile getGameProfile(Player player) {
        return this.getGameProfile.apply(player);
    }

    @Override
    public Component getDisplayName(Player player) {
        return this.getDisplayName.apply(player);
    }

    @Override
    public void setDisplayName(MCPlayer player, Component displayName) {
        this.setDisplayName.accept(player, displayName);
    }

    @Override
    public Channel getChannel(Player player) {
        return ThrowingSupplier.sneaky(() -> {
            Object handle = this.getHandle.invoke((Object)player, new Object[0]);
            Object connection = this.playerConnection.get(handle);
            Object manager = this.networkManager.get(connection);
            return (Channel)this.channel.get(manager);
        }).get();
    }
}

