/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.player.movement.impl;

import io.fairyproject.bukkit.player.movement.MovementListener;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public abstract class AbstractMovementImplementation {
    private MovementListener movementListener;
    private boolean ignoreSameBlock;
    private boolean ignoreSameY;

    public AbstractMovementImplementation(MovementListener movementListener) {
        this.movementListener = movementListener;
    }

    public AbstractMovementImplementation ignoreSameBlock() {
        this.ignoreSameBlock = true;
        return this;
    }

    public AbstractMovementImplementation ignoreSameBlockAndY() {
        this.ignoreSameBlock = true;
        this.ignoreSameY = true;
        return this;
    }

    public void register(Plugin plugin) {
    }

    public void unregister() {
    }

    public void updateLocation(Player player, Location from, Location to) {
        if (from.getX() != to.getX() || from.getY() != to.getY() || from.getZ() != to.getZ()) {
            boolean cancelled = false;
            if (this.isIgnoreSameBlock() && from.getBlockX() == to.getBlockX() && from.getBlockZ() == to.getBlockZ() && (this.isIgnoreSameY() || from.getBlockY() == to.getBlockY())) {
                cancelled = true;
            }
            if (!cancelled) {
                this.movementListener.handleUpdateLocation(player, from, to);
            }
        }
    }

    public void updateRotation(Player player, Location from, Location to) {
        if (from.getYaw() != to.getYaw() || from.getPitch() != to.getPitch()) {
            this.movementListener.handleUpdateRotation(player, from, to);
        }
    }

    public MovementListener getMovementListener() {
        return this.movementListener;
    }

    public boolean isIgnoreSameBlock() {
        return this.ignoreSameBlock;
    }

    public boolean isIgnoreSameY() {
        return this.ignoreSameY;
    }
}

