/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.plugin;

import io.fairyproject.bukkit.FairyBukkitPlatform;
import io.fairyproject.bukkit.util.JavaPluginUtil;
import io.fairyproject.plugin.PluginHandler;
import io.fairyproject.reflect.wrapper.ReflectWrapper;
import io.fairyproject.util.AccessUtil;
import io.fairyproject.util.exceptionally.SneakyThrowUtil;
import java.lang.reflect.Field;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;

public class BukkitPluginHandler
implements PluginHandler {
    private final Field field;

    public BukkitPluginHandler() {
        Field field;
        try {
            Class<?> pluginClassLoader = ReflectWrapper.get().findClass("org.bukkit.plugin.java.PluginClassLoader");
            field = ReflectWrapper.get().findField(pluginClassLoader, "plugin");
            AccessUtil.setAccessible(field);
        }
        catch (Throwable throwable) {
            SneakyThrowUtil.sneakyThrow(throwable);
            field = null;
        }
        this.field = field;
    }

    @Override
    @Nullable
    public String getPluginByClass(Class<?> type) {
        try {
            JavaPlugin plugin = JavaPluginUtil.getProvidingPlugin(type);
            if (plugin != null) {
                return plugin.getName();
            }
        }
        catch (Throwable plugin) {
            // empty catch block
        }
        try {
            ClassLoader classLoader = type.getClassLoader();
            Plugin plugin = (Plugin)this.field.get(classLoader);
            return plugin.getName();
        }
        catch (Throwable ignored) {
            return FairyBukkitPlatform.PLUGIN.getName();
        }
    }
}

