/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.scheduler.folia;

import io.fairyproject.bukkit.scheduler.folia.FoliaScheduledTask;
import io.fairyproject.bukkit.scheduler.folia.wrapper.WrapperScheduledTask;
import io.fairyproject.log.Log;
import io.fairyproject.mc.scheduler.MCTickBasedScheduler;
import io.fairyproject.scheduler.repeat.RepeatPredicate;
import io.fairyproject.scheduler.response.TaskResponse;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class FoliaAbstractScheduler
implements MCTickBasedScheduler {
    protected <R> io.fairyproject.scheduler.ScheduledTask<R> doSchedule(Callable<R> callable, Function<Consumer<ScheduledTask>, ScheduledTask> schedule) {
        CompletableFuture future = new CompletableFuture();
        ScheduledTask rawScheduledTask = schedule.apply(task -> {
            if (future.isDone()) {
                return;
            }
            try {
                future.complete(callable.call());
            }
            catch (Throwable throwable) {
                Log.error("An error occurred while executing a scheduled task", throwable, new Object[0]);
                future.completeExceptionally(throwable);
            }
        });
        return new FoliaScheduledTask(WrapperScheduledTask.of(rawScheduledTask), future);
    }

    @Override
    public io.fairyproject.scheduler.ScheduledTask<?> schedule(Runnable runnable) {
        return this.schedule(() -> {
            runnable.run();
            return null;
        });
    }

    @Override
    public io.fairyproject.scheduler.ScheduledTask<?> schedule(Runnable runnable, long delayTicks) {
        return this.schedule(() -> {
            runnable.run();
            return null;
        }, delayTicks);
    }

    @Override
    public io.fairyproject.scheduler.ScheduledTask<?> scheduleAtFixedRate(Runnable runnable, long delayTicks, long intervalTicks, RepeatPredicate<?> predicate) {
        return this.scheduleAtFixedRate(() -> {
            runnable.run();
            return TaskResponse.continueTask();
        }, delayTicks, intervalTicks, predicate);
    }
}

