/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.scheduler.folia;

import io.fairyproject.bukkit.scheduler.folia.FoliaAbstractScheduler;
import io.fairyproject.bukkit.scheduler.folia.FoliaRepeatedScheduledTask;
import io.fairyproject.bukkit.scheduler.folia.wrapper.WrapperScheduledTask;
import io.fairyproject.mc.scheduler.MCMillisBasedScheduler;
import io.fairyproject.scheduler.repeat.RepeatPredicate;
import io.fairyproject.scheduler.response.TaskResponse;
import io.papermc.paper.threadedregions.scheduler.AsyncScheduler;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class FoliaAsyncScheduler
extends FoliaAbstractScheduler
implements MCMillisBasedScheduler {
    private final AsyncScheduler scheduler;
    private final Plugin bukkitPlugin;

    public FoliaAsyncScheduler(Plugin bukkitPlugin) {
        this.bukkitPlugin = bukkitPlugin;
        this.scheduler = Bukkit.getAsyncScheduler();
    }

    @Override
    public boolean isCurrentThread() {
        return Thread.currentThread().getName().contains("Folia Async Scheduler Thread");
    }

    @Override
    public <R> io.fairyproject.scheduler.ScheduledTask<R> schedule(Callable<R> callable) {
        return this.doSchedule(callable, task -> this.scheduler.runNow(this.bukkitPlugin, task));
    }

    @Override
    public <R> io.fairyproject.scheduler.ScheduledTask<R> schedule(Callable<R> callable, Duration delay) {
        return this.doSchedule(callable, task -> this.scheduler.runDelayed(this.bukkitPlugin, task, delay.toNanos(), TimeUnit.NANOSECONDS));
    }

    @Override
    public io.fairyproject.scheduler.ScheduledTask<?> scheduleAtFixedRate(Runnable runnable, long delayTicks, long intervalTicks) {
        return this.scheduleAtFixedRate(runnable, Duration.ofMillis(delayTicks * 50L), Duration.ofMillis(intervalTicks * 50L));
    }

    @Override
    public io.fairyproject.scheduler.ScheduledTask<?> scheduleAtFixedRate(Runnable runnable, Duration duration, Duration interval) {
        return this.scheduleAtFixedRate(() -> {
            runnable.run();
            return TaskResponse.continueTask();
        }, duration, interval, RepeatPredicate.empty());
    }

    @Override
    public io.fairyproject.scheduler.ScheduledTask<?> scheduleAtFixedRate(Runnable runnable, long delayTicks, long intervalTicks, RepeatPredicate<?> predicate) {
        return this.scheduleAtFixedRate(() -> {
            runnable.run();
            return TaskResponse.continueTask();
        }, delayTicks, intervalTicks, predicate);
    }

    @Override
    public <R> io.fairyproject.scheduler.ScheduledTask<R> scheduleAtFixedRate(Callable<TaskResponse<R>> callback, Duration delayTicks, Duration intervalTicks, RepeatPredicate<R> repeatPredicate) {
        FoliaRepeatedScheduledTask<R> task = new FoliaRepeatedScheduledTask<R>(callback, repeatPredicate);
        ScheduledTask rawScheduledTask = this.scheduler.runAtFixedRate(this.bukkitPlugin, task, delayTicks.toNanos(), intervalTicks.toNanos(), TimeUnit.NANOSECONDS);
        task.setScheduledTask(WrapperScheduledTask.of(rawScheduledTask));
        return task;
    }

    @Override
    public io.fairyproject.scheduler.ScheduledTask<?> scheduleAtFixedRate(Runnable runnable, Duration duration, Duration interval, RepeatPredicate<?> predicate) {
        return this.scheduleAtFixedRate(() -> {
            runnable.run();
            return TaskResponse.continueTask();
        }, duration, interval, predicate);
    }

    @Override
    public <R> io.fairyproject.scheduler.ScheduledTask<R> scheduleAtFixedRate(Callable<TaskResponse<R>> callback, long delayTicks, long intervalTicks) {
        return this.scheduleAtFixedRate(callback, Duration.ofMillis(delayTicks * 50L), Duration.ofMillis(intervalTicks * 50L));
    }

    @Override
    public <R> io.fairyproject.scheduler.ScheduledTask<R> scheduleAtFixedRate(Callable<TaskResponse<R>> callback, Duration duration, Duration interval) {
        return this.scheduleAtFixedRate(callback, duration, interval, RepeatPredicate.empty());
    }

    @Override
    public <R> io.fairyproject.scheduler.ScheduledTask<R> scheduleAtFixedRate(Callable<TaskResponse<R>> callback, long delayTicks, long intervalTicks, RepeatPredicate<R> predicate) {
        return this.scheduleAtFixedRate(callback, Duration.ofMillis(delayTicks * 50L), Duration.ofMillis(intervalTicks * 50L), predicate);
    }

    @Override
    public io.fairyproject.scheduler.ScheduledTask<?> schedule(Runnable runnable, long delayTicks) {
        return this.schedule(runnable, Duration.ofMillis(delayTicks * 50L));
    }
}

