/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.scheduler.folia;

import io.fairyproject.bukkit.scheduler.folia.wrapper.WrapperScheduledTask;
import io.fairyproject.log.Log;
import io.fairyproject.scheduler.repeat.RepeatPredicate;
import io.fairyproject.scheduler.response.TaskResponse;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class FoliaRepeatedScheduledTask<R>
implements io.fairyproject.scheduler.ScheduledTask<R>,
Consumer<ScheduledTask> {
    private final CompletableFuture<R> future = new CompletableFuture();
    private final Callable<TaskResponse<R>> callable;
    private final RepeatPredicate<R> repeatPredicate;
    private WrapperScheduledTask scheduledTask;

    @Override
    public CompletableFuture<R> getFuture() {
        return this.future;
    }

    @Override
    public void accept(ScheduledTask scheduledTask) {
        WrapperScheduledTask wrapperScheduledTask = WrapperScheduledTask.of(scheduledTask);
        try {
            TaskResponse<R> response = this.callable.call();
            switch (response.getState()) {
                case SUCCESS: {
                    this.future.complete(response.getResult());
                    wrapperScheduledTask.cancel();
                    break;
                }
                case FAILURE: {
                    Throwable throwable = response.getThrowable();
                    String errorMessage = response.getErrorMessage();
                    if (throwable != null) {
                        this.future.completeExceptionally(throwable);
                    } else {
                        this.future.completeExceptionally(new IllegalStateException(errorMessage));
                    }
                    wrapperScheduledTask.cancel();
                    break;
                }
                case CONTINUE: {
                    if (!this.repeatPredicate.shouldContinue(this)) {
                        this.future.complete(this.repeatPredicate.getDefaultValue());
                        wrapperScheduledTask.cancel();
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + (Object)((Object)response.getState()));
                }
            }
        }
        catch (Exception e) {
            Log.error("An error occurred while executing a scheduled task", e, new Object[0]);
            this.future.completeExceptionally(e);
            wrapperScheduledTask.cancel();
        }
    }

    @Override
    public void cancel() {
        this.future.cancel(false);
        this.scheduledTask.cancel();
    }

    public FoliaRepeatedScheduledTask(Callable<TaskResponse<R>> callable, RepeatPredicate<R> repeatPredicate) {
        this.callable = callable;
        this.repeatPredicate = repeatPredicate;
    }

    public void setScheduledTask(WrapperScheduledTask scheduledTask) {
        this.scheduledTask = scheduledTask;
    }
}

