/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.scheduler.folia;

import io.fairyproject.bukkit.scheduler.folia.FoliaAsyncScheduler;
import io.fairyproject.bukkit.scheduler.folia.FoliaEntityScheduler;
import io.fairyproject.bukkit.scheduler.folia.FoliaGlobalRegionScheduler;
import io.fairyproject.bukkit.scheduler.folia.FoliaRegionScheduler;
import io.fairyproject.bukkit.util.BukkitPos;
import io.fairyproject.mc.MCWorld;
import io.fairyproject.mc.scheduler.MCScheduler;
import io.fairyproject.mc.scheduler.MCSchedulerProvider;
import io.fairyproject.mc.util.Position;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class FoliaSchedulerProvider
implements MCSchedulerProvider {
    private final Plugin plugin;

    @Override
    public MCScheduler getGlobalScheduler() {
        return new FoliaGlobalRegionScheduler(this.plugin);
    }

    @Override
    public MCScheduler getAsyncScheduler() {
        return new FoliaAsyncScheduler(this.plugin);
    }

    @Override
    public MCScheduler getEntityScheduler(Object entity) {
        if (entity instanceof Entity) {
            return new FoliaEntityScheduler((Entity)entity, this.plugin);
        }
        throw new IllegalArgumentException("entity must be an instance of org.bukkit.entity.Entity");
    }

    @Override
    public MCScheduler getLocationScheduler(Position position) {
        return new FoliaRegionScheduler(this.plugin, BukkitPos.toBukkitLocation(position));
    }

    @Override
    public MCScheduler getChunkScheduler(MCWorld world, int chunkX, int chunkZ) {
        return new FoliaRegionScheduler(this.plugin, world.as(World.class), chunkX, chunkZ);
    }

    public FoliaSchedulerProvider(Plugin plugin) {
        this.plugin = plugin;
    }
}

