/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.timer;

import io.fairyproject.bukkit.timer.PlayerCooldown;
import io.fairyproject.bukkit.util.items.behaviour.ItemBehaviour;
import io.fairyproject.libs.kyori.adventure.text.Component;
import io.fairyproject.mc.MCAdventure;
import io.fairyproject.mc.MCPlayer;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public final class TimedItemBehaviours {
    public static ItemBehaviour cooldown(ItemBehaviour behaviour, long defaultCooldown, Plugin plugin) {
        return TimedItemBehaviours.cooldown(behaviour, defaultCooldown, null, null, plugin);
    }

    public static ItemBehaviour cooldown(ItemBehaviour behaviour, long defaultCooldown, @Nullable Component cooldownMessage, @Nullable Component removeMessage, Plugin plugin) {
        PlayerCooldown cooldown = new PlayerCooldown(defaultCooldown, player -> {
            if (removeMessage != null) {
                player.sendMessage(MCAdventure.asJsonString(removeMessage, MCPlayer.from(player).getLocale()));
            }
        }, plugin);
        return behaviour.filter((player, itemStack) -> {
            if (cooldown.isCooldown(player)) {
                if (cooldownMessage != null) {
                    player.sendMessage(MCAdventure.asJsonString(cooldownMessage, MCPlayer.from(player).getLocale()));
                }
                return false;
            }
            cooldown.addCooldown(player);
            return true;
        });
    }

    private TimedItemBehaviours() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

