/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.timings;

import io.fairyproject.bukkit.timings.EmptyTiming;
import io.fairyproject.bukkit.timings.MCTiming;
import io.fairyproject.bukkit.timings.Minecraft18Timing;
import io.fairyproject.bukkit.timings.MinecraftTiming;
import io.fairyproject.bukkit.timings.SpigotCustomTiming;
import io.fairyproject.bukkit.timings.UnitTestingTiming;
import org.bukkit.plugin.Plugin;

enum TimingType {
    SPIGOT(true){

        @Override
        MCTiming newTiming(Plugin plugin, String command, MCTiming parent) {
            return new SpigotCustomTiming(command);
        }
    }
    ,
    MINECRAFT{

        @Override
        MCTiming newTiming(Plugin plugin, String command, MCTiming parent) {
            return new MinecraftTiming(plugin, command, parent);
        }
    }
    ,
    MINECRAFT_18{

        @Override
        MCTiming newTiming(Plugin plugin, String command, MCTiming parent) {
            try {
                return new Minecraft18Timing(plugin, command, parent);
            }
            catch (Throwable e) {
                return new EmptyTiming();
            }
        }
    }
    ,
    UNIT_TESTING{

        @Override
        MCTiming newTiming(Plugin plugin, String command, MCTiming parent) {
            return new UnitTestingTiming(plugin, command, parent);
        }
    }
    ,
    EMPTY;

    private final boolean useCache;

    public boolean useCache() {
        return this.useCache;
    }

    private TimingType() {
        this(false);
    }

    private TimingType(boolean useCache) {
        this.useCache = useCache;
    }

    MCTiming newTiming(Plugin plugin, String command, MCTiming parent) {
        return new EmptyTiming();
    }
}

