/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.util.items.behaviour;

import io.fairyproject.bukkit.listener.ListenerRegistry;
import io.fairyproject.bukkit.util.items.FairyItem;
import io.fairyproject.bukkit.util.items.behaviour.ItemBehaviourEvent;
import io.fairyproject.bukkit.util.items.behaviour.ItemBehaviourInteract;
import io.fairyproject.bukkit.util.items.behaviour.ItemBehaviourPlace;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.inventory.ItemStack;

public abstract class ItemBehaviour {
    protected FairyItem item;
    private final List<BiPredicate<Player, ItemStack>> filters = new ArrayList<BiPredicate<Player, ItemStack>>(1);

    public static ItemBehaviour interact(ListenerRegistry listenerRegistry, ItemBehaviourInteract.Callback callback, Action ... allowedActions) {
        return new ItemBehaviourInteract(listenerRegistry, callback, allowedActions);
    }

    public static ItemBehaviour blockPlace(ListenerRegistry listenerRegistry, ItemBehaviourPlace.Callback callback) {
        return new ItemBehaviourPlace(listenerRegistry, callback);
    }

    public static <E extends Event> ItemBehaviour ofEvent(Class<E> classToRegister, final BiConsumer<E, ItemBehaviourEvent<E>> listener) {
        final AtomicReference<1> reference = new AtomicReference<1>();
        reference.set(new ItemBehaviourEvent<E>(classToRegister){

            @Override
            public void call(E event) {
                listener.accept(event, (ItemBehaviourEvent)reference.get());
            }
        });
        return (ItemBehaviour)reference.get();
    }

    public ItemBehaviour() {
        if (this.shouldFilterItemKey()) {
            this.filter((player, itemStack) -> this.item.isSimilar((ItemStack)itemStack));
        }
    }

    public boolean shouldFilterItemKey() {
        return true;
    }

    public final void init(FairyItem item) {
        this.item = item;
        this.onInit(item);
    }

    protected void onInit(FairyItem item) {
    }

    public void unregister() {
    }

    public ItemBehaviour filter(BiPredicate<Player, ItemStack> filter) {
        this.filters.add(filter);
        return this;
    }

    public boolean matches(Player player, ItemStack itemStack) {
        for (BiPredicate<Player, ItemStack> filter : this.filters) {
            if (filter.test(player, itemStack)) continue;
            return false;
        }
        return true;
    }

    public FairyItem getItem() {
        return this.item;
    }

    public List<BiPredicate<Player, ItemStack>> getFilters() {
        return this.filters;
    }
}

