/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.util.items.behaviour;

import io.fairyproject.bukkit.FairyBukkitPlatform;
import io.fairyproject.bukkit.listener.events.EventSubscription;
import io.fairyproject.bukkit.listener.events.Events;
import io.fairyproject.bukkit.util.items.FairyItem;
import io.fairyproject.bukkit.util.items.behaviour.ItemBehaviour;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public abstract class ItemBehaviourEvent<E extends Event>
extends ItemBehaviour {
    private final Class<E> classToRegister;
    private EventSubscription<E> subscription;

    public ItemBehaviourEvent(Class<E> classToRegister) {
        this.classToRegister = classToRegister;
    }

    @Override
    public void onInit(FairyItem item) {
        this.subscription = Events.subscribe(this.classToRegister).listen((subscription, e) -> this.call(e)).build((Plugin)FairyBukkitPlatform.PLUGIN);
    }

    @Override
    public void unregister() {
        super.unregister();
        if (this.subscription != null) {
            this.subscription.unregister();
        }
    }

    public abstract void call(E var1);

    public Class<E> getClassToRegister() {
        return this.classToRegister;
    }

    public EventSubscription<E> getSubscription() {
        return this.subscription;
    }
}

