/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.visibility;

import io.fairyproject.bukkit.visibility.VisibilityAdapter;
import io.fairyproject.bukkit.visibility.VisibilityOption;
import io.fairyproject.container.ContainerContext;
import io.fairyproject.container.PreInitialize;
import io.fairyproject.container.Service;
import io.fairyproject.container.collection.ContainerObjCollector;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

@Service
public class VisibilityService {
    private List<VisibilityAdapter> visibilityAdapters;

    @PreInitialize
    public void preInit() {
        this.visibilityAdapters = new LinkedList<VisibilityAdapter>();
        ContainerContext.get().objectCollectorRegistry().add(ContainerObjCollector.create().withFilter(ContainerObjCollector.inherits(VisibilityAdapter.class)).withAddHandler(ContainerObjCollector.warpInstance(VisibilityAdapter.class, this::register)).withRemoveHandler(ContainerObjCollector.warpInstance(VisibilityAdapter.class, this::unregister)));
    }

    public void register(VisibilityAdapter visibilityAdapter) {
        this.visibilityAdapters.add(visibilityAdapter);
    }

    public void unregister(VisibilityAdapter visibilityAdapter) {
        this.visibilityAdapters.remove(visibilityAdapter);
    }

    public boolean isUsed() {
        return !this.visibilityAdapters.isEmpty();
    }

    public boolean treatAsOnline(Player target, Player viewer) {
        return viewer.canSee(target);
    }

    public void updateAll() {
        if (!this.isUsed()) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.updateFromThirdSide(player);
        }
    }

    public void update(Player player) {
        if (this.isUsed()) {
            this.updateFromFirstSide(player);
            this.updateFromThirdSide(player);
        }
    }

    public void updateFromFirstSide(Player player) {
        for (Player target : Bukkit.getOnlinePlayers()) {
            if (target == player) continue;
            if (this.canSee(player, target)) {
                player.showPlayer(target);
                continue;
            }
            player.hidePlayer(target);
        }
    }

    public void updateFromThirdSide(Player player) {
        for (Player target : Bukkit.getOnlinePlayers()) {
            if (target == player) continue;
            if (this.canSee(target, player)) {
                target.showPlayer(player);
                continue;
            }
            target.hidePlayer(player);
        }
    }

    public boolean canSee(Player receiver, Player target) {
        for (VisibilityAdapter visibilityAdapter : this.visibilityAdapters) {
            VisibilityOption option = visibilityAdapter.check(receiver, target);
            switch (option) {
                case SHOW: {
                    return true;
                }
                case HIDE: {
                    return false;
                }
            }
        }
        return true;
    }
}

