/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.bukkit.visual;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import io.fairyproject.bukkit.listener.RegisterAsListener;
import io.fairyproject.bukkit.listener.events.Events;
import io.fairyproject.bukkit.nms.BukkitNMSManager;
import io.fairyproject.bukkit.util.CoordXZ;
import io.fairyproject.bukkit.util.CoordinatePair;
import io.fairyproject.bukkit.visual.VisualBlock;
import io.fairyproject.bukkit.visual.VisualBlockClaim;
import io.fairyproject.bukkit.visual.VisualBlockGenerator;
import io.fairyproject.bukkit.visual.VisualPosition;
import io.fairyproject.bukkit.visual.VisualTask;
import io.fairyproject.bukkit.visual.event.PreHandleVisualClaimEvent;
import io.fairyproject.bukkit.visual.event.PreHandleVisualEvent;
import io.fairyproject.bukkit.visual.sender.VisualBlockSender;
import io.fairyproject.bukkit.visual.type.VisualType;
import io.fairyproject.container.InjectableComponent;
import io.fairyproject.container.PostInitialize;
import io.fairyproject.container.PreDestroy;
import io.fairyproject.libs.xseries.XMaterial;
import io.fairyproject.log.Log;
import io.fairyproject.mc.scheduler.MCSchedulerProvider;
import io.fairyproject.mc.util.BlockPosition;
import io.fairyproject.plugin.Plugin;
import io.fairyproject.plugin.PluginListenerAdapter;
import io.fairyproject.plugin.PluginManager;
import io.fairyproject.scheduler.response.TaskResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

@InjectableComponent
@RegisterAsListener
public class VisualBlockService
implements Listener {
    private final Table<UUID, VisualPosition, VisualBlock> table = HashBasedTable.create();
    private final LoadingCache<CoordinatePair, Optional<VisualBlockClaim>> claimCache;
    private final Table<CoordinatePair, CoordXZ, VisualBlockClaim> claimPositionTable;
    private final Queue<VisualTask> visualTasks = new ConcurrentLinkedQueue<VisualTask>();
    private final Map<Plugin, List<VisualBlockGenerator>> dynamicVisualGenerator = new ConcurrentHashMap<Plugin, List<VisualBlockGenerator>>();
    private final BukkitNMSManager nmsManager;
    private final MCSchedulerProvider mcSchedulerProvider;
    private VisualBlockSender visualBlockSender;
    private VisualBlockGenerator mainGenerator;
    private boolean destroyed;

    public VisualBlockService(BukkitNMSManager nmsManager, MCSchedulerProvider mcSchedulerProvider) {
        this.nmsManager = nmsManager;
        this.mcSchedulerProvider = mcSchedulerProvider;
        this.claimPositionTable = HashBasedTable.create();
        this.claimCache = CacheBuilder.newBuilder().maximumSize(8000L).build((CacheLoader)new CacheLoader<CoordinatePair, Optional<VisualBlockClaim>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Optional<VisualBlockClaim> load(@NotNull CoordinatePair key) {
                int chunkX = key.getX() >> 4;
                int chunkZ = key.getZ() >> 4;
                int posX = key.getX() % 16;
                int posZ = key.getZ() % 16;
                Table table = VisualBlockService.this.claimPositionTable;
                synchronized (table) {
                    return Optional.ofNullable((VisualBlockClaim)VisualBlockService.this.claimPositionTable.get((Object)new CoordinatePair(key.getWorldName(), chunkX, chunkZ), (Object)new CoordXZ((byte)posX, (byte)posZ)));
                }
            }
        });
    }

    @PostInitialize
    public void onPostInitialize() {
        this.visualBlockSender = new VisualBlockSender(this.nmsManager);
        this.mcSchedulerProvider.getGlobalScheduler().scheduleAtFixedRate(this::onTick, 1L, 1L);
        this.mainGenerator = (player, location, positions) -> {
            int minHeight = location.getBlockY() - 5;
            int maxHeight = location.getBlockY() + 4;
            int toX = location.getBlockX();
            int toZ = location.getBlockZ();
            HashSet<VisualBlockClaim> claimCache = new HashSet<VisualBlockClaim>();
            for (int x = toX - 7; x < toX + 7; ++x) {
                for (int z = toZ - 7; z < toZ + 7; ++z) {
                    VisualBlockClaim color = this.getClaimAt(location.getWorld(), x, z);
                    PreHandleVisualClaimEvent claimEvent = new PreHandleVisualClaimEvent(player, color);
                    Events.call(claimEvent);
                    if (color == null || claimEvent.isCancelled()) continue;
                    claimCache.add(color);
                }
            }
            if (!claimCache.isEmpty()) {
                Iterator claims = claimCache.iterator();
                while (claims.hasNext()) {
                    VisualBlockClaim claim = (VisualBlockClaim)claims.next();
                    VisualType type = claim.getType();
                    for (Vector edge : this.getEdges(claim)) {
                        if (Math.abs(edge.getBlockX() - toX) > 7 || Math.abs(edge.getBlockZ() - toZ) > 7) continue;
                        Location location2 = edge.toLocation(location.getWorld());
                        for (int y = minHeight; y <= maxHeight; ++y) {
                            positions.add(new VisualPosition(location2.getBlockX(), y, location2.getBlockZ(), player.getWorld().getName(), type));
                        }
                    }
                    claims.remove();
                }
            }
        };
        PluginManager.INSTANCE.registerListener(new PluginListenerAdapter(){

            @Override
            public void onPluginDisable(Plugin plugin) {
                VisualBlockService.this.dynamicVisualGenerator.remove(plugin);
            }
        });
    }

    @PreDestroy
    public void onPreDestroy() {
        this.destroyed = true;
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (!Events.IGNORE_SAME_BLOCK.test(event)) {
            return;
        }
        this.handlePositionChanged(event.getPlayer(), event.getTo());
    }

    public void registerGenerator(VisualBlockGenerator blockGenerator) {
        List<Object> blockGenerators;
        Plugin plugin = PluginManager.INSTANCE.getPluginByClass(blockGenerator.getClass());
        if (plugin == null) {
            throw new IllegalArgumentException("Not a Plugin?");
        }
        if (this.dynamicVisualGenerator.containsKey(plugin)) {
            blockGenerators = this.dynamicVisualGenerator.get(plugin);
        } else {
            blockGenerators = new ArrayList();
            this.dynamicVisualGenerator.put(plugin, blockGenerators);
        }
        blockGenerators.add(blockGenerator);
        Log.info(String.valueOf(this.dynamicVisualGenerator.containsKey(plugin)), new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheClaim(VisualBlockClaim claim) {
        World world = claim.getWorld();
        int minX = Math.min(claim.getMaxX(), claim.getMinX());
        int maxX = Math.max(claim.getMaxX(), claim.getMinX());
        int minZ = Math.min(claim.getMaxZ(), claim.getMinZ());
        int maxZ = Math.max(claim.getMaxZ(), claim.getMinZ());
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                CoordinatePair worldPosition = new CoordinatePair(world, x, z);
                CoordinatePair chunkPair = new CoordinatePair(world, x >> 4, z >> 4);
                CoordXZ chunkPosition = new CoordXZ((byte)(x % 16), (byte)(z % 16));
                Table<CoordinatePair, CoordXZ, VisualBlockClaim> table = this.claimPositionTable;
                synchronized (table) {
                    this.claimPositionTable.put((Object)chunkPair, (Object)chunkPosition, (Object)claim);
                }
                this.claimCache.invalidate((Object)worldPosition);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClaim(VisualBlockClaim claim) {
        World world = claim.getWorld();
        int minX = Math.min(claim.getMaxX(), claim.getMinX());
        int maxX = Math.max(claim.getMaxX(), claim.getMinX());
        int minZ = Math.min(claim.getMaxZ(), claim.getMinZ());
        int maxZ = Math.max(claim.getMaxZ(), claim.getMinZ());
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                CoordinatePair worldPosition = new CoordinatePair(world, x, z);
                CoordinatePair chunkPair = new CoordinatePair(world, x >> 4, z >> 4);
                CoordXZ chunkPosition = new CoordXZ((byte)(x % 16), (byte)(z % 16));
                Table<CoordinatePair, CoordXZ, VisualBlockClaim> table = this.claimPositionTable;
                synchronized (table) {
                    this.claimPositionTable.remove((Object)chunkPair, (Object)chunkPosition);
                }
                this.claimCache.invalidate((Object)worldPosition);
            }
        }
    }

    public void clearAll(Player player, boolean send) {
        this.table.rowMap().remove(player.getUniqueId());
        this.visualBlockSender.clearFakeBlocks(player, send);
    }

    public void clearVisualType(Player player, VisualType visualType, boolean send) {
        this.clearVisualType(player, visualType, null, send);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearVisualType(Player player, VisualType visualType, Predicate<VisualBlock> predicate, boolean send) {
        ArrayList<BlockPosition> removeFromClient = new ArrayList<BlockPosition>();
        Table<UUID, VisualPosition, VisualBlock> table = this.table;
        synchronized (table) {
            Map currentBlocks = this.table.row((Object)player.getUniqueId());
            for (Map.Entry entry : new ArrayList(currentBlocks.entrySet())) {
                VisualPosition blockPosition = (VisualPosition)entry.getKey();
                VisualBlock visualBlock = (VisualBlock)entry.getValue();
                VisualType blockVisualType = visualBlock.getVisualType();
                if (!blockVisualType.equals(visualType) || predicate != null && !predicate.test(visualBlock)) continue;
                removeFromClient.add(blockPosition);
                currentBlocks.remove(blockPosition);
            }
        }
        this.visualBlockSender.send(player, Collections.emptyMap(), removeFromClient, send);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<BlockPosition, XMaterial> addVisualType(Player player, Collection<VisualPosition> locations, boolean send) {
        HashMap<BlockPosition, XMaterial> sendToClient = new HashMap<BlockPosition, XMaterial>();
        this.removeBlockFromSolid(player, locations);
        Table<UUID, VisualPosition, VisualBlock> table = this.table;
        synchronized (table) {
            for (VisualPosition blockPosition : locations) {
                VisualType visualType = blockPosition.getType();
                XMaterial material = visualType.generate(player, blockPosition);
                sendToClient.put(blockPosition, material);
                this.table.put((Object)player.getUniqueId(), (Object)blockPosition, (Object)new VisualBlock(visualType, material, blockPosition));
            }
        }
        this.visualBlockSender.send(player, sendToClient, Collections.emptyList(), send);
        return sendToClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<BlockPosition, XMaterial> setVisualType(Player player, Collection<VisualPosition> locations, boolean send) {
        HashMap<BlockPosition, XMaterial> sendToClient = new HashMap<BlockPosition, XMaterial>();
        ArrayList<BlockPosition> removeFromClient = new ArrayList<BlockPosition>();
        this.removeBlockFromSolid(player, locations);
        Table<UUID, VisualPosition, VisualBlock> table = this.table;
        synchronized (table) {
            Map currentBlocks = this.table.row((Object)player.getUniqueId());
            for (Map.Entry entry : new ArrayList(currentBlocks.entrySet())) {
                VisualPosition blockPosition = (VisualPosition)entry.getKey();
                VisualBlock visualBlock = (VisualBlock)entry.getValue();
                VisualType blockVisualType = visualBlock.getVisualType();
                if (!blockVisualType.equals(blockPosition.getType()) || locations.remove(blockPosition)) continue;
                removeFromClient.add(blockPosition);
                currentBlocks.remove(blockPosition);
            }
            for (VisualPosition blockPosition : locations) {
                VisualType visualType = blockPosition.getType();
                XMaterial material = visualType.generate(player, blockPosition);
                sendToClient.put(blockPosition, material);
                this.table.put((Object)player.getUniqueId(), (Object)blockPosition, (Object)new VisualBlock(visualType, material, blockPosition));
            }
        }
        this.visualBlockSender.send(player, sendToClient, removeFromClient, send);
        return sendToClient;
    }

    public boolean isVisualBlock(Player player, int x, int y, int z) {
        return this.table.contains((Object)player.getUniqueId(), (Object)new VisualPosition(x, y, z, player.getWorld().getName(), null));
    }

    public VisualBlock getVisualBlock(Player player, int x, int y, int z) {
        return (VisualBlock)this.table.get((Object)player.getUniqueId(), (Object)new VisualPosition(x, y, z, player.getWorld().getName(), null));
    }

    private void removeBlockFromSolid(Player player, Collection<VisualPosition> locations) {
        locations.removeIf(blockPosition -> {
            if (!blockPosition.getType().isBlockedBySolid(player, (BlockPosition)blockPosition)) {
                return false;
            }
            World world = player.getWorld();
            Block block = world.getBlockAt(blockPosition.getX(), blockPosition.getY(), blockPosition.getZ());
            Material material = block.getType();
            return material.isSolid();
        });
    }

    public VisualBlockClaim getClaimAt(Location location) {
        return this.getClaimAt(location.getWorld(), location.getBlockX(), location.getBlockZ());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VisualBlockClaim getClaimAt(World world, int x, int z) {
        try {
            return ((Optional)this.claimCache.get((Object)new CoordinatePair(world, x, z))).orElse(null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            int chunkX = x >> 4;
            int chunkZ = z >> 4;
            byte posX = (byte)(x % 16);
            byte posZ = (byte)(z % 16);
            Table<CoordinatePair, CoordXZ, VisualBlockClaim> table = this.claimPositionTable;
            synchronized (table) {
                return (VisualBlockClaim)this.claimPositionTable.get((Object)new CoordinatePair(world, chunkX, chunkZ), (Object)new CoordXZ(posX, posZ));
            }
        }
    }

    public void handlePositionChanged(Player player, Location location) {
        if (this.claimPositionTable.isEmpty() && this.dynamicVisualGenerator.isEmpty()) {
            return;
        }
        PreHandleVisualEvent event = new PreHandleVisualEvent(player);
        Events.call(event);
        if (event.isCancelled()) {
            return;
        }
        HashSet<VisualPosition> blockPositions = new HashSet<VisualPosition>();
        this.mainGenerator.generate(player, location, blockPositions);
        for (Map.Entry<Plugin, List<VisualBlockGenerator>> blockGenerators : this.dynamicVisualGenerator.entrySet()) {
            blockGenerators.getValue().forEach(blockGenerator -> blockGenerator.generate(player, location, blockPositions));
        }
        if (player.isOnline()) {
            this.visualTasks.removeIf(visualTask -> visualTask.getPlayer() == player);
            this.visualTasks.add(new VisualTask(player, blockPositions));
        }
    }

    public List<Vector> getEdges(VisualBlockClaim claim) {
        int z;
        int minX = Math.min(claim.getMinX(), claim.getMaxX());
        int maxX = Math.max(claim.getMinX(), claim.getMaxX());
        int minZ = Math.min(claim.getMinZ(), claim.getMaxZ());
        int startX = minZ + 1;
        int maxZ = Math.max(claim.getMinZ(), claim.getMaxZ());
        int capacity = (maxX - minX) * 4 + (maxZ - minZ) * 4;
        if ((capacity += 4) <= 0) {
            return new ArrayList<Vector>();
        }
        ArrayList<Vector> result = new ArrayList<Vector>(capacity);
        int minY = Math.min(claim.getMinY(), claim.getMaxY());
        int maxY = Math.max(claim.getMinY(), claim.getMaxY());
        for (z = minX; z <= maxX; ++z) {
            result.add(new Vector(z, minY, minZ));
            result.add(new Vector(z, minY, maxZ));
            result.add(new Vector(z, maxY, minZ));
            result.add(new Vector(z, maxY, maxZ));
        }
        for (z = startX; z < maxZ; ++z) {
            result.add(new Vector(minX, minY, z));
            result.add(new Vector(minX, maxY, z));
            result.add(new Vector(maxX, minY, z));
            result.add(new Vector(maxX, maxY, z));
        }
        return result;
    }

    public void addVisualTask(Player player, VisualTask task) {
        this.visualTasks.removeIf(otherTask -> otherTask.getPlayer() == player);
        this.visualTasks.add(task);
    }

    public void clear() {
        Bukkit.getOnlinePlayers().forEach(player -> this.clearAll((Player)player, true));
    }

    public TaskResponse<Void> onTick() {
        VisualTask visualTask;
        if (this.destroyed) {
            return TaskResponse.success(null);
        }
        while ((visualTask = this.visualTasks.poll()) != null) {
            this.setVisualType(visualTask.getPlayer(), visualTask.getBlockPositions(), true);
        }
        return TaskResponse.continueTask();
    }

    public VisualBlockSender getVisualBlockSender() {
        return this.visualBlockSender;
    }
}

