/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.command;

import io.fairyproject.Debug;
import io.fairyproject.command.BaseCommand;
import io.fairyproject.command.CommandContext;
import io.fairyproject.command.CommandListener;
import io.fairyproject.command.PresenceProvider;
import io.fairyproject.command.annotation.Command;
import io.fairyproject.command.annotation.CommandPresence;
import io.fairyproject.command.argument.ArgCompletionHolder;
import io.fairyproject.command.exception.ArgTransformException;
import io.fairyproject.command.parameter.ArgTransformer;
import io.fairyproject.container.ContainerContext;
import io.fairyproject.container.InjectableComponent;
import io.fairyproject.container.PostInitialize;
import io.fairyproject.container.PreInitialize;
import io.fairyproject.container.collection.ContainerObjCollector;
import io.fairyproject.util.PreProcessBatch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

@InjectableComponent
public class CommandService {
    public static CommandService INSTANCE;
    private final ContainerContext context;
    private Map<Class<?>, ArgTransformer<?>> parameters;
    private Map<Class<?>, PresenceProvider<?>> presenceProvidersByHolder;
    private Map<Class<?>, PresenceProvider<?>> defaultPresenceProviders;
    private Map<String, ArgCompletionHolder> tabCompletionHolders;
    private List<CommandListener> listeners;
    private Map<String, BaseCommand> commands;
    private PreProcessBatch batch;

    @PreInitialize
    public void preInit() {
        this.batch = PreProcessBatch.create();
        this.parameters = new HashMap();
        this.presenceProvidersByHolder = new ConcurrentHashMap();
        this.defaultPresenceProviders = new ConcurrentHashMap();
        this.tabCompletionHolders = new ConcurrentHashMap<String, ArgCompletionHolder>();
        this.listeners = new ArrayList<CommandListener>();
        this.commands = new ConcurrentHashMap<String, BaseCommand>();
        this.context.objectCollectorRegistry().add(ContainerObjCollector.create().withFilter(ContainerObjCollector.inherits(ArgCompletionHolder.class)).withAddHandler(ContainerObjCollector.warpInstance(ArgCompletionHolder.class, handler -> this.tabCompletionHolders.put(handler.name(), (ArgCompletionHolder)handler))).withRemoveHandler(ContainerObjCollector.warpInstance(ArgCompletionHolder.class, handler -> this.tabCompletionHolders.remove(handler.name()))));
        this.context.objectCollectorRegistry().add(ContainerObjCollector.create().withFilter(ContainerObjCollector.inherits(BaseCommand.class)).withFilter(obj -> obj.getType().isAnnotationPresent(Command.class)).withAddHandler(ContainerObjCollector.warpInstance(BaseCommand.class, instance -> this.batch.runOrQueue(instance.getClass().getName(), () -> this.registerCommand(instance)))).withRemoveHandler(ContainerObjCollector.warpInstance(BaseCommand.class, instance -> {
            if (!this.batch.remove(instance.getClass().getName())) {
                this.unregisterCommand(instance);
            }
        })));
        this.context.objectCollectorRegistry().add(ContainerObjCollector.create().withFilter(ContainerObjCollector.inherits(ArgTransformer.class)).withAddHandler(ContainerObjCollector.warpInstance(ArgTransformer.class, this::registerArgTransformer)).withRemoveHandler(ContainerObjCollector.warpInstance(ArgTransformer.class, this::unregisterArgTransformer)));
    }

    @PostInitialize
    public void onPostInitialize() {
        INSTANCE = this;
        Debug.log("Injecting fairy commands...", new Object[0]);
        try {
            this.batch.flushQueue();
        }
        finally {
            Debug.log("Injected!", new Object[0]);
        }
    }

    public void addCommandListener(CommandListener commandListener) {
        this.listeners.add(commandListener);
    }

    public void removeCommandListener(CommandListener commandListener) {
        this.listeners.remove(commandListener);
    }

    public void registerDefaultPresenceProvider(PresenceProvider<?> presenceProvider) {
        this.defaultPresenceProviders.put(presenceProvider.type(), presenceProvider);
    }

    public void registerArgTransformer(ArgTransformer<?> parameterHolder) {
        for (Class type : parameterHolder.type()) {
            this.parameters.put(type, parameterHolder);
        }
    }

    public void unregisterArgTransformer(ArgTransformer<?> parameterHolder) {
        for (Class type : parameterHolder.type()) {
            this.parameters.remove(type, parameterHolder);
        }
    }

    public PresenceProvider<?> getPresenceProviderByAnnotation(CommandPresence annotation) {
        Class<PresenceProvider<?>> type = annotation.value();
        if (this.presenceProvidersByHolder.containsKey(type)) {
            return this.presenceProvidersByHolder.get(type);
        }
        PresenceProvider<?> presenceProvider = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.presenceProvidersByHolder.put(type, presenceProvider);
        return presenceProvider;
    }

    @Nullable
    public PresenceProvider<?> getPresenceProviderByType(Class<?> type) {
        return this.defaultPresenceProviders.getOrDefault(type, null);
    }

    public void registerCommand(Object object) {
        BaseCommand command = (BaseCommand)object;
        command.init();
        String[] commandNames = command.getCommandNames();
        for (String name : commandNames) {
            this.commands.put(name, command);
        }
        for (CommandListener listener : this.listeners) {
            listener.onCommandInitial(command, commandNames);
        }
    }

    public void unregisterCommand(Object object) {
        String[] commandNames;
        BaseCommand command = (BaseCommand)object;
        for (String name : commandNames = command.getCommandNames()) {
            this.commands.put(name, command);
        }
        this.listeners.forEach(listener -> listener.onCommandRemoval(command));
    }

    public Object transformParameter(CommandContext event, String source, Class type) {
        if (type == String.class) {
            return source;
        }
        ArgTransformer holder = this.parameters.getOrDefault(type, null);
        if (holder != null) {
            return holder.transform(event, source);
        }
        if (type.isEnum()) {
            try {
                return Enum.valueOf(type, source);
            }
            catch (IllegalArgumentException ignored) {
                throw new ArgTransformException("Unmatched type: " + Stream.of(type.getEnumConstants()).map(obj -> (Enum)obj).map(Enum::name).collect(Collectors.joining(", ")));
            }
        }
        return null;
    }

    public ArgCompletionHolder getTabCompletionHolder(String name) {
        return this.tabCompletionHolders.get(name);
    }

    public List<String> tabCompleteParameters(CommandContext commandContext, String parameter, Class<?> transformTo) {
        ArgTransformer argTransformer = this.parameters.getOrDefault(transformTo, null);
        if (argTransformer == null) {
            if (transformTo.isEnum()) {
                ArrayList<String> strings = new ArrayList<String>();
                for (Object constant : transformTo.getEnumConstants()) {
                    String name = ((Enum)constant).name();
                    if (!name.toLowerCase().startsWith(parameter.toLowerCase())) continue;
                    strings.add(name);
                }
                return strings;
            }
            return Collections.emptyList();
        }
        return argTransformer.tabComplete(commandContext, parameter);
    }

    public CommandService(ContainerContext context) {
        this.context = context;
    }

    public ContainerContext getContext() {
        return this.context;
    }

    public Map<Class<?>, ArgTransformer<?>> getParameters() {
        return this.parameters;
    }

    public Map<Class<?>, PresenceProvider<?>> getPresenceProvidersByHolder() {
        return this.presenceProvidersByHolder;
    }

    public Map<Class<?>, PresenceProvider<?>> getDefaultPresenceProviders() {
        return this.defaultPresenceProviders;
    }

    public Map<String, ArgCompletionHolder> getTabCompletionHolders() {
        return this.tabCompletionHolders;
    }

    public List<CommandListener> getListeners() {
        return this.listeners;
    }

    public Map<String, BaseCommand> getCommands() {
        return this.commands;
    }

    public PreProcessBatch getBatch() {
        return this.batch;
    }
}

