/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.command.parameter.impl;

import io.fairyproject.command.CommandContext;
import io.fairyproject.command.parameter.ArgTransformer;
import io.fairyproject.container.object.Obj;

@Obj
public class LongArgTransformer
implements ArgTransformer<Long> {
    @Override
    public Class[] type() {
        return new Class[]{Long.class, Long.TYPE};
    }

    @Override
    public Long transform(CommandContext event, String source) {
        if (source.toLowerCase().contains("e")) {
            return (Long)this.fail(source + " is not a valid number.");
        }
        try {
            long parsed = Long.parseLong(source);
            if (Double.isNaN(parsed) || !Double.isFinite(parsed)) {
                return (Long)this.fail(source + " is not a valid number.");
            }
            return parsed;
        }
        catch (NumberFormatException exception) {
            return (Long)this.fail(source + " is not a valid number.");
        }
    }
}

