/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.config;

import io.fairyproject.config.Configuration;
import io.fairyproject.config.Converter;
import io.fairyproject.config.Converters;
import io.fairyproject.config.Reflect;
import io.fairyproject.config.Validator;
import io.fairyproject.config.annotation.Format;
import io.fairyproject.config.filter.FieldFilter;
import io.fairyproject.config.format.FieldNameFormatter;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.persistence.Transient;

public final class FieldMapper
extends Enum<FieldMapper> {
    private static final /* synthetic */ FieldMapper[] $VALUES;

    public static FieldMapper[] values() {
        return (FieldMapper[])$VALUES.clone();
    }

    public static FieldMapper valueOf(String name) {
        return Enum.valueOf(FieldMapper.class, name);
    }

    public static Map<String, Object> instanceToMap(Object inst, MappingInfo mappingInfo) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Configuration.Properties props = mappingInfo.getProperties();
        FieldFilter filter = props.getFilter();
        for (Field field : filter.filterDeclaredFieldsOf(inst.getClass())) {
            if (field.getAnnotation(Transient.class) != null) continue;
            Object val = FieldMapper.toConvertibleObject(field, inst, mappingInfo);
            FieldNameFormatter fnf = FieldMapper.selectFormatter(mappingInfo);
            String fn = fnf.fromFieldName(field.getName());
            map.put(fn, val);
        }
        return map;
    }

    private static Object toConvertibleObject(Field field, Object instance, MappingInfo mappingInfo) {
        FieldMapper.checkDefaultValueNull(field, instance);
        Converter.ConversionInfo info = Converter.ConversionInfo.from(field, instance, mappingInfo);
        Validator.checkFieldWithElementTypeIsContainer(info);
        Object converted = Converters.convertTo(info);
        Validator.checkConverterNotReturnsNull(converted, info);
        return converted;
    }

    public static void instanceFromMap(Object inst, Map<String, Object> instMap, MappingInfo mappingInfo) {
        FieldFilter filter = mappingInfo.getProperties().getFilter();
        for (Field field : filter.filterDeclaredFieldsOf(inst.getClass())) {
            FieldNameFormatter fnf;
            String fn;
            Object mapValue;
            if (field.getAnnotation(Transient.class) != null || (mapValue = instMap.get(fn = (fnf = FieldMapper.selectFormatter(mappingInfo)).fromFieldName(field.getName()))) == null) continue;
            FieldMapper.fromConvertedObject(field, inst, mapValue, mappingInfo);
        }
    }

    private static void fromConvertedObject(Field field, Object instance, Object mapValue, MappingInfo mappingInfo) {
        FieldMapper.checkDefaultValueNull(field, instance);
        Converter.ConversionInfo info = Converter.ConversionInfo.from(field, instance, mapValue, mappingInfo);
        Validator.checkFieldWithElementTypeIsContainer(info);
        Object convert = Converters.convertFrom(info);
        if (convert == null) {
            return;
        }
        if (Reflect.isContainerType(info.getFieldType())) {
            Validator.checkFieldTypeAssignableFrom(convert.getClass(), info);
        }
        Reflect.setValue(field, instance, convert);
    }

    private static void checkDefaultValueNull(Field field, Object instance) {
        Object val = Reflect.getValue(field, instance);
        Validator.checkNotNull(val, field.getName());
    }

    static FieldNameFormatter selectFormatter(MappingInfo info) {
        Configuration<?> configuration = info.getConfiguration();
        Configuration.Properties props = info.getProperties();
        if (configuration != null && Reflect.hasFormatter(configuration.getClass())) {
            Format format = configuration.getClass().getAnnotation(Format.class);
            return format.formatterClass() != FieldNameFormatter.class ? Reflect.newInstance(format.formatterClass()) : format.value();
        }
        return props.getFormatter();
    }

    private static /* synthetic */ FieldMapper[] $values() {
        return new FieldMapper[0];
    }

    static {
        $VALUES = FieldMapper.$values();
    }

    public static final class MappingInfo {
        private final Configuration<?> configuration;
        private final Configuration.Properties properties;

        MappingInfo(Configuration<?> configuration, Configuration.Properties properties) {
            this.configuration = configuration;
            this.properties = properties;
        }

        Configuration<?> getConfiguration() {
            return this.configuration;
        }

        Configuration.Properties getProperties() {
            return this.properties;
        }

        static MappingInfo from(Configuration<?> configuration) {
            return new MappingInfo(configuration, configuration.getProperties());
        }
    }
}

