/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.container.binder;

import io.fairyproject.container.binder.ContainerObjectBinder;
import io.fairyproject.container.object.ContainerObj;
import io.fairyproject.container.type.TypeDescriptor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainerObjectBinderImpl
implements ContainerObjectBinder {
    private final Map<Class<?>, ContainerObj> bindings = new ConcurrentHashMap();
    private final Map<TypeDescriptor, ContainerObj> typeDescriptorBindings = new ConcurrentHashMap<TypeDescriptor, ContainerObj>();

    @Override
    @Nullable
    public ContainerObj getBinding(Class<?> type) {
        ContainerObj obj = this.bindings.get(type);
        if (obj == null) {
            obj = this.findBindingAssignableByType(type);
        }
        return obj;
    }

    @Override
    @Nullable
    public ContainerObj getExactBinding(Class<?> classType) {
        return this.bindings.get(classType);
    }

    private ContainerObj findBindingAssignableByType(Class<?> type) {
        for (ContainerObj value : this.bindings.values()) {
            Class<?> valueType = value.getType();
            if (!type.isAssignableFrom(valueType)) continue;
            return value;
        }
        return null;
    }

    @Override
    public boolean isBound(Class<?> type) {
        return this.getBinding(type) != null;
    }

    @Override
    public void bind(Class<?> type, ContainerObj object) {
        this.bindings.put(type, object);
        this.typeDescriptorBindings.put(object.getTypeDescriptor(), object);
    }

    @Override
    public void unbind(Class<?> type) {
        ContainerObj obj = this.bindings.remove(type);
        if (obj != null) {
            this.typeDescriptorBindings.remove(obj.getTypeDescriptor());
        }
    }

    @Override
    @Nullable
    public ContainerObj getBinding(@NotNull TypeDescriptor typeDescriptor) {
        ContainerObj obj = this.typeDescriptorBindings.get(typeDescriptor);
        if (obj != null) {
            return obj;
        }
        for (Map.Entry<TypeDescriptor, ContainerObj> entry : this.typeDescriptorBindings.entrySet()) {
            if (!entry.getKey().isAssignableTo(typeDescriptor)) continue;
            return entry.getValue();
        }
        return this.getBinding(typeDescriptor.getRawType());
    }

    @Override
    public boolean isBound(@NotNull TypeDescriptor typeDescriptor) {
        return this.getBinding(typeDescriptor) != null;
    }

    @Override
    public void bind(@NotNull TypeDescriptor typeDescriptor, @NotNull ContainerObj object) {
        this.typeDescriptorBindings.put(typeDescriptor, object);
        this.bindings.put(typeDescriptor.getRawType(), object);
    }
}

