/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.container.collection;

import io.fairyproject.container.ContainerContext;
import io.fairyproject.container.Containers;
import io.fairyproject.container.collection.ContainerObjCollectorImpl;
import io.fairyproject.container.object.ContainerObj;
import io.fairyproject.util.ConditionUtils;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface ContainerObjCollector
extends Iterable<ContainerObj>,
Predicate<ContainerObj> {
    public static ContainerObjCollector create() {
        return new ContainerObjCollectorImpl();
    }

    public static Predicate<ContainerObj> inherits(Class<?> classInherit) {
        return containerObj -> classInherit.isAssignableFrom(containerObj.getType());
    }

    @Deprecated
    public static <T> Consumer<ContainerObj> warpInstance(Class<T> type, Consumer<T> consumer) {
        return containerObj -> {
            ContainerContext context = Containers.CONTAINER_CONTEXT;
            Object instance = context.singletonObjectRegistry().getSingleton(containerObj.getType());
            ConditionUtils.notNull(instance, "The instance of the container object hasn't been constructed.");
            ConditionUtils.is(type.isAssignableFrom(containerObj.getType()), String.format("The container object type %s doesn't match with %s", containerObj.getType(), type));
            consumer.accept(type.cast(instance));
        };
    }

    @Contract(value="_ -> this")
    public ContainerObjCollector withFilter(@NotNull Predicate<ContainerObj> var1);

    @Contract(value="_ -> this")
    public ContainerObjCollector withAddHandler(@NotNull Consumer<ContainerObj> var1);

    @Contract(value="_ -> this")
    public ContainerObjCollector withRemoveHandler(@NotNull Consumer<ContainerObj> var1);

    public void add(@NotNull ContainerObj var1);

    public boolean remove(@NotNull ContainerObj var1);

    @NotNull
    public Collection<ContainerObj> all();
}

