/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.container.node;

import io.fairyproject.util.AsyncUtils;
import io.fairyproject.util.ConditionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public abstract class Graph<T> {
    protected final Set<T> objects = new HashSet<T>();
    protected final Map<T, List<T>> edges = new HashMap<T, List<T>>();
    private final AtomicBoolean resolved = new AtomicBoolean(false);
    private List<T> nodes;

    public abstract T[] depends(T var1);

    public void handleCycle(T current, List<T> diagram) {
        throw new IllegalArgumentException("Diagram shows this graph contains cycle: " + diagram.stream().map(t -> {
            if (t == current) {
                return "*" + t.toString() + "*";
            }
            return t.toString();
        }).collect(Collectors.joining(",")));
    }

    public void add(@NotNull T obj) {
        ConditionUtils.is(!this.resolved.get(), "The DependencyTree was resolved.");
        this.objects.add(obj);
    }

    public Graph<T> resolve() {
        ConditionUtils.is(this.resolved.compareAndSet(false, true), "The DependencyTree was resolved.");
        for (T object : this.objects) {
            T[] depends;
            for (T depend : depends = this.depends(object)) {
                boolean containsDepend = this.objects.contains(depend);
                ConditionUtils.is(containsDepend, String.format("%s depend by %s", depend, object));
                this.edges.computeIfAbsent(depend, k -> new ArrayList()).add(object);
            }
        }
        ArrayList<T> array = new ArrayList<T>(this.objects);
        Stack stack = new Stack();
        boolean[] visited = new boolean[this.objects.size()];
        boolean[] recStack = new boolean[this.objects.size()];
        for (int i = 0; i < array.size(); ++i) {
            this.resolveElement(array.get(i), i, stack, array, visited, recStack, Collections.emptyList());
        }
        this.nodes = new ArrayList<T>(this.objects.size());
        while (!stack.empty()) {
            Object element = stack.pop();
            this.nodes.add(element);
        }
        this.nodes = new ArrayList<T>(this.nodes);
        return this;
    }

    public boolean isResolved() {
        return this.resolved.get();
    }

    private void resolveElement(@NotNull T element, int index, @NotNull Stack<T> stack, @NotNull List<T> array, boolean @NotNull [] visited, boolean @NotNull [] recStack, @NotNull List<T> diagram) {
        if (recStack[index]) {
            this.handleCycle(element, diagram);
            return;
        }
        if (visited[index]) {
            return;
        }
        visited[index] = true;
        recStack[index] = true;
        for (Object child : this.edges.getOrDefault(element, Collections.emptyList())) {
            ConditionUtils.is(this.objects.contains(element), "Child " + child + " wasn't an element of this dependency tree");
            int childIndex = array.indexOf(child);
            ArrayList<T> newDiagram = new ArrayList<T>(diagram);
            newDiagram.add(child);
            this.resolveElement(child, childIndex, stack, array, visited, recStack, newDiagram);
        }
        recStack[index] = false;
        stack.push(element);
    }

    public CompletableFuture<?> forEachClockwiseAwait(Function<T, CompletableFuture<?>> func) {
        ConditionUtils.is(this.resolved.get(), "The DependencyTree wasn't resolved.");
        HashMap<T, CompletionStage> futures = new HashMap<T, CompletionStage>();
        for (Object t : this.nodes) {
            T[] depends = this.depends(t);
            ArrayList dependFutures = new ArrayList(depends.length);
            for (T depend : depends) {
                CompletableFuture future = (CompletableFuture)futures.get(depend);
                dependFutures.add(future);
            }
            CompletionStage future = AsyncUtils.allOf(dependFutures).thenCompose(k -> (CompletionStage)func.apply(t));
            futures.put(t, future);
        }
        return AsyncUtils.allOf(futures.values());
    }

    public CompletableFuture<?> forEachCounterClockwiseAwait(Function<T, CompletableFuture<?>> func) {
        ConditionUtils.is(this.resolved.get(), "The DependencyTree wasn't resolved.");
        HashMap futures = new HashMap();
        this.forEachCounterClockwise(t -> {
            List child = this.edges.getOrDefault(t, Collections.emptyList());
            ArrayList childFutures = new ArrayList(child.size());
            for (Object depend : child) {
                CompletableFuture future = (CompletableFuture)futures.get(depend);
                childFutures.add(future);
            }
            CompletionStage future = AsyncUtils.allOf(childFutures).thenCompose(k -> (CompletionStage)func.apply(t));
            futures.put(t, future);
        });
        return AsyncUtils.allOf(futures.values());
    }

    public void forEachClockwise(Consumer<T> consumer) {
        ConditionUtils.is(this.resolved.get(), "The DependencyTree wasn't resolved.");
        this.nodes.forEach(consumer);
    }

    public void forEachCounterClockwise(Consumer<T> consumer) {
        ConditionUtils.is(this.resolved.get(), "The DependencyTree wasn't resolved.");
        for (int i = this.nodes.size() - 1; i >= 0; --i) {
            consumer.accept(this.nodes.get(i));
        }
    }

    public List<T> getNodes() {
        return this.nodes;
    }
}

