/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.container.object.provider;

import io.fairyproject.container.ContainerConstruct;
import io.fairyproject.container.object.provider.InstanceProvider;
import io.fairyproject.container.type.TypeDescriptor;
import io.fairyproject.container.util.GenericTypeUtils;
import io.fairyproject.util.AccessUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import org.jetbrains.annotations.NotNull;

public class ConstructorInstanceProvider
implements InstanceProvider {
    private final Class<?> type;
    private final Constructor<?> constructor;
    private final TypeDescriptor[] parameterTypeDescriptors;

    public ConstructorInstanceProvider(Class<?> type) throws ReflectiveOperationException {
        if (Modifier.isAbstract(type.getModifiers())) {
            throw new IllegalArgumentException("The type " + type.getName() + " is abstract!");
        }
        this.type = type;
        this.constructor = this.resolveConstructor();
        Parameter[] parameters = this.constructor.getParameters();
        this.parameterTypeDescriptors = new TypeDescriptor[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            this.parameterTypeDescriptors[i] = GenericTypeUtils.getTypeDescriptorFromParameter(parameters[i]);
        }
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public Class<?>[] getDependencies() {
        return this.constructor.getParameterTypes();
    }

    @Override
    @NotNull
    public Object provide(Object[] objects) throws Exception {
        return this.constructor.newInstance(objects);
    }

    private Constructor<?> resolveConstructor() throws ReflectiveOperationException {
        Constructor<?> bestConstructor = null;
        int bestPriority = -1;
        for (Constructor<?> constructor : this.type.getDeclaredConstructors()) {
            AccessUtil.setAccessible(constructor);
            int priority = -1;
            ContainerConstruct annotation = constructor.getAnnotation(ContainerConstruct.class);
            if (annotation != null) {
                priority = annotation.priority();
            }
            if (bestConstructor != null && bestPriority >= priority) continue;
            bestConstructor = constructor;
            bestPriority = priority;
        }
        if (bestConstructor == null) {
            bestConstructor = this.type.getDeclaredConstructor(new Class[0]);
        }
        return bestConstructor;
    }

    public TypeDescriptor[] getParameterTypeDescriptors() {
        return this.parameterTypeDescriptors;
    }
}

