/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.container.object.resolver;

import io.fairyproject.container.binder.ContainerObjectBinder;
import io.fairyproject.container.object.ContainerObj;
import io.fairyproject.container.object.resolver.ContainerObjectFactory;
import io.fairyproject.container.object.resolver.ContainerObjectResolver;
import io.fairyproject.container.type.TypeDescriptor;
import io.fairyproject.util.ConditionUtils;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;

public class ContainerObjectResolverImpl
implements ContainerObjectResolver {
    private final ContainerObjectBinder binder;
    private final ContainerObjectFactory singletonObjectFactory;
    private final ContainerObjectFactory prototypeObjectFactory;

    @Override
    @NotNull
    public CompletableFuture<Object[]> resolveInstances(@NotNull Class<?>[] types) throws Exception {
        Object[] args = new Object[types.length];
        CompletableFuture[] futures = new CompletableFuture[types.length];
        for (int i = 0; i < args.length; ++i) {
            Class<?> type = types[i];
            int index = i;
            futures[i] = this.resolveInstance(type).thenAccept(instance -> {
                args[index] = instance;
            });
        }
        return CompletableFuture.allOf(futures).thenApply($ -> args);
    }

    @Override
    @NotNull
    public CompletableFuture<Object> resolveInstance(@NotNull Class<?> type) throws Exception {
        CompletableFuture<Object> future;
        ContainerObj object = this.binder.getBinding(type);
        ConditionUtils.notNull(object, String.format("Couldn't find container object %s!", type.getName()));
        switch (object.getScope()) {
            case SINGLETON: {
                future = this.singletonObjectFactory.createInstance(object.getType());
                break;
            }
            case PROTOTYPE: {
                future = this.prototypeObjectFactory.createInstance(object.getType());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)object.getScope()));
            }
        }
        return future;
    }

    @Override
    @NotNull
    public CompletableFuture<Object> resolveInstance(@NotNull TypeDescriptor typeDescriptor) throws Exception {
        CompletableFuture<Object> future;
        ContainerObj object = this.binder.getBinding(typeDescriptor);
        ConditionUtils.notNull(object, String.format("Couldn't find container object %s!", typeDescriptor));
        switch (object.getScope()) {
            case SINGLETON: {
                future = this.singletonObjectFactory.createInstance(typeDescriptor);
                break;
            }
            case PROTOTYPE: {
                future = this.prototypeObjectFactory.createInstance(typeDescriptor);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)object.getScope()));
            }
        }
        return future;
    }

    public ContainerObjectResolverImpl(ContainerObjectBinder binder, ContainerObjectFactory singletonObjectFactory, ContainerObjectFactory prototypeObjectFactory) {
        this.binder = binder;
        this.singletonObjectFactory = singletonObjectFactory;
        this.prototypeObjectFactory = prototypeObjectFactory;
    }
}

