/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.container.processor.annotation;

import io.fairyproject.util.AccessUtil;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;

public class LifeCycleElement {
    private final MethodHandle methodHandle;
    private final String identifier;

    public LifeCycleElement(Method method) {
        AccessUtil.setAccessible(method);
        this.methodHandle = MethodHandles.lookup().unreflect(method);
        this.identifier = String.format("%s # %s", method.getClass().getName(), method.getName());
    }

    public void invoke(Object instance) {
        this.methodHandle.invoke(instance);
    }

    public String getIdentifier() {
        return this.identifier;
    }
}

