/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.container.processor.injection;

import io.fairyproject.container.object.ContainerObj;
import io.fairyproject.container.processor.ContainerObjDestroyProcessor;
import io.fairyproject.container.processor.ContainerObjInitProcessor;
import io.fairyproject.data.MetaKey;
import io.fairyproject.event.Event;
import io.fairyproject.event.EventNode;
import io.fairyproject.event.EventSubscribeRegistry;
import io.fairyproject.event.GlobalEventNode;
import io.fairyproject.util.AsyncUtils;
import java.util.concurrent.CompletableFuture;

public class SubscribeEventAnnotationProcessor
implements ContainerObjInitProcessor,
ContainerObjDestroyProcessor {
    private static final MetaKey<EventNode> KEY = MetaKey.create("fairy:event-node", EventNode.class);

    @Override
    public CompletableFuture<?> processPostInitialization(ContainerObj object, Object instance) {
        if (!object.isSingletonScope()) {
            return AsyncUtils.empty();
        }
        EventNode<? extends Event> eventNode = EventSubscribeRegistry.create(instance);
        if (eventNode != null) {
            GlobalEventNode.get().addChild(eventNode);
            object.getMetadata().put(KEY, eventNode);
        }
        return AsyncUtils.empty();
    }

    @Override
    public void processPreDestroy(ContainerObj object, Object instance) {
        object.getMetadata().ifPresent(KEY, eventNode -> GlobalEventNode.get().removeChild((EventNode<Event>)eventNode));
    }
}

