/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.container.type;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeDescriptor {
    private final Class<?> rawType;
    private final Type[] genericTypes;

    public TypeDescriptor(@NotNull Class<?> rawType) {
        this(rawType, null);
    }

    public TypeDescriptor(@NotNull Class<?> rawType, @Nullable Type[] genericTypes) {
        this.rawType = rawType;
        this.genericTypes = genericTypes;
    }

    public static TypeDescriptor fromType(Type type) {
        ParameterizedType parameterizedType;
        Type rawType;
        if (type instanceof Class) {
            return new TypeDescriptor((Class)type);
        }
        if (type instanceof ParameterizedType && (rawType = (parameterizedType = (ParameterizedType)type).getRawType()) instanceof Class) {
            return new TypeDescriptor((Class)rawType, parameterizedType.getActualTypeArguments());
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    public boolean isAssignableTo(TypeDescriptor target) {
        if (!target.getRawType().isAssignableFrom(this.rawType)) {
            return false;
        }
        if (target.getGenericTypes() == null || target.getGenericTypes().length == 0) {
            return true;
        }
        if (this.genericTypes == null || this.genericTypes.length == 0) {
            return false;
        }
        if (this.genericTypes.length != target.getGenericTypes().length) {
            return false;
        }
        for (int i = 0; i < this.genericTypes.length; ++i) {
            Type thisType = this.genericTypes[i];
            Type targetType = target.getGenericTypes()[i];
            if (!(targetType instanceof Class) || !(thisType instanceof Class) || ((Class)targetType).isAssignableFrom((Class)thisType)) continue;
            return false;
        }
        return true;
    }

    public Class<?> getRawType() {
        return this.rawType;
    }

    public Type[] getGenericTypes() {
        return this.genericTypes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TypeDescriptor)) {
            return false;
        }
        TypeDescriptor other = (TypeDescriptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Class<?> this$rawType = this.getRawType();
        Class<?> other$rawType = other.getRawType();
        if (this$rawType == null ? other$rawType != null : !this$rawType.equals(other$rawType)) {
            return false;
        }
        return Arrays.deepEquals(this.getGenericTypes(), other.getGenericTypes());
    }

    protected boolean canEqual(Object other) {
        return other instanceof TypeDescriptor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<?> $rawType = this.getRawType();
        result = result * 59 + ($rawType == null ? 43 : $rawType.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getGenericTypes());
        return result;
    }

    public String toString() {
        return "TypeDescriptor(rawType=" + this.getRawType() + ", genericTypes=" + Arrays.deepToString(this.getGenericTypes()) + ")";
    }
}

