/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.event;

import io.fairyproject.event.Event;
import io.fairyproject.event.EventListener;
import io.fairyproject.event.EventNode;
import io.fairyproject.event.Subscribe;
import io.fairyproject.util.ConditionUtils;
import io.fairyproject.util.Utility;
import io.fairyproject.util.exceptionally.SneakyThrowUtil;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EventSubscribeRegistry {
    @Nullable
    public static EventNode<? extends Event> create(@NotNull Object listener) {
        EventNode<Event> eventNode = EventNode.all(listener.getClass().getName());
        AtomicInteger count = new AtomicInteger(0);
        Utility.getSuperClasses(listener.getClass()).stream().flatMap(type -> Stream.of(type.getDeclaredMethods())).forEach(method -> {
            Subscribe subscribe = method.getAnnotation(Subscribe.class);
            if (subscribe == null) {
                return;
            }
            ConditionUtils.is(method.getParameterCount() == 1, "The method " + method + " is subscribing event but parameter count isn't 1");
            Class<?> parameterType = method.getParameterTypes()[0];
            Class<Event> eventType = parameterType.asSubclass(Event.class);
            EventListener<Event> eventListener = EventListener.builder(eventType).ignoreCancelled(subscribe.ignoreCancelled()).handler(new AnnotatedHandler(listener, (Method)method)).build();
            count.incrementAndGet();
            eventNode.addListener(eventListener);
        });
        if (count.get() > 0) {
            return eventNode;
        }
        return null;
    }

    private EventSubscribeRegistry() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class AnnotatedHandler<T>
    implements Consumer<T> {
        private final Object listener;
        private final MethodHandle method;

        public AnnotatedHandler(Object listener, Method method) {
            this.listener = listener;
            MethodHandle retMethod = null;
            try {
                method.setAccessible(true);
                retMethod = MethodHandles.lookup().unreflect(method);
            }
            catch (IllegalAccessException e) {
                SneakyThrowUtil.sneakyThrow(e);
            }
            this.method = retMethod;
        }

        @Override
        public void accept(T t) {
            try {
                this.method.invoke(this.listener, t);
            }
            catch (Throwable e) {
                SneakyThrowUtil.sneakyThrow(e);
            }
        }
    }
}

