/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.libs.packetevents;

import io.fairyproject.libs.packetevents.event.EventManager;
import io.fairyproject.libs.packetevents.injector.ChannelInjector;
import io.fairyproject.libs.packetevents.manager.player.PlayerManager;
import io.fairyproject.libs.packetevents.manager.protocol.ProtocolManager;
import io.fairyproject.libs.packetevents.manager.server.ServerManager;
import io.fairyproject.libs.packetevents.netty.NettyManager;
import io.fairyproject.libs.packetevents.settings.PacketEventsSettings;
import io.fairyproject.libs.packetevents.util.LogManager;
import io.fairyproject.libs.packetevents.util.PEVersion;
import io.fairyproject.libs.packetevents.util.PEVersions;
import io.fairyproject.libs.packetevents.util.updatechecker.UpdateChecker;
import java.util.logging.Logger;

public abstract class PacketEventsAPI<T> {
    private final EventManager eventManager = new EventManager();
    private final PacketEventsSettings settings = new PacketEventsSettings();
    private final UpdateChecker updateChecker = new UpdateChecker();
    private final LogManager logManager = new LogManager();
    private static final Logger LOGGER = Logger.getLogger(PacketEventsAPI.class.getName());

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public PacketEventsSettings getSettings() {
        return this.settings;
    }

    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    public PEVersion getVersion() {
        return PEVersions.CURRENT;
    }

    public Logger getLogger() {
        return LOGGER;
    }

    public LogManager getLogManager() {
        return this.logManager;
    }

    public abstract void load();

    public abstract boolean isLoaded();

    public abstract void init();

    public abstract boolean isInitialized();

    public abstract void terminate();

    public abstract boolean isTerminated();

    public abstract T getPlugin();

    public abstract ServerManager getServerManager();

    public abstract ProtocolManager getProtocolManager();

    public abstract PlayerManager getPlayerManager();

    public abstract NettyManager getNettyManager();

    public abstract ChannelInjector getInjector();
}

