/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.libs.packetevents.protocol.dialog;

import io.fairyproject.libs.kyori.adventure.dialog.DialogLike;
import io.fairyproject.libs.packetevents.protocol.dialog.DialogType;
import io.fairyproject.libs.packetevents.protocol.dialog.DialogTypes;
import io.fairyproject.libs.packetevents.protocol.dialog.Dialogs;
import io.fairyproject.libs.packetevents.protocol.mapper.CopyableEntity;
import io.fairyproject.libs.packetevents.protocol.mapper.DeepComparableEntity;
import io.fairyproject.libs.packetevents.protocol.mapper.MappedEntity;
import io.fairyproject.libs.packetevents.protocol.nbt.NBT;
import io.fairyproject.libs.packetevents.protocol.nbt.NBTCompound;
import io.fairyproject.libs.packetevents.protocol.nbt.NBTString;
import io.fairyproject.libs.packetevents.util.mappings.TypesBuilderData;
import io.fairyproject.libs.packetevents.wrapper.PacketWrapper;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public interface Dialog
extends MappedEntity,
DeepComparableEntity,
CopyableEntity<Dialog>,
DialogLike {
    public static Dialog read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntityOrDirect(Dialogs.getRegistry(), Dialog::readDirect);
    }

    public static void write(PacketWrapper<?> wrapper, Dialog dialog) {
        wrapper.writeMappedEntityOrDirect(dialog, Dialog::writeDirect);
    }

    public static Dialog readDirect(PacketWrapper<?> wrapper) {
        return Dialog.decodeDirect(wrapper.readNBTRaw(), wrapper, null);
    }

    public static void writeDirect(PacketWrapper<?> wrapper, Dialog dialog) {
        wrapper.writeNBTRaw(Dialog.encodeDirect(dialog, wrapper));
    }

    public static Dialog decode(NBT nbt, PacketWrapper<?> wrapper) {
        if (nbt instanceof NBTString) {
            return wrapper.replaceRegistry(Dialogs.getRegistry()).getByNameOrThrow(((NBTString)nbt).getValue());
        }
        return Dialog.decodeDirect(nbt, wrapper, null);
    }

    public static NBT encode(PacketWrapper<?> wrapper, Dialog dialog) {
        if (dialog.isRegistered()) {
            return new NBTString(dialog.getName().toString());
        }
        return Dialog.encodeDirect(dialog, wrapper);
    }

    @ApiStatus.Internal
    public static Dialog decodeDirect(NBT nbt, PacketWrapper<?> wrapper, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        String dialogTypeName = compound.getStringTagValueOrThrow("type");
        DialogType dialogType = (DialogType)DialogTypes.getRegistry().getByNameOrThrow(dialogTypeName);
        return (Dialog)dialogType.decode(compound, wrapper).copy(data);
    }

    @ApiStatus.Internal
    public static NBT encodeDirect(Dialog dialog, PacketWrapper<?> wrapper) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("type", new NBTString(dialog.getType().getName().toString()));
        dialog.getType().encode(compound, wrapper, dialog);
        return compound;
    }

    public DialogType<?> getType();
}

