/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.libs.packetevents.protocol.world.positionsource.builtin;

import io.fairyproject.libs.packetevents.protocol.nbt.NBTCompound;
import io.fairyproject.libs.packetevents.protocol.nbt.NBTIntArray;
import io.fairyproject.libs.packetevents.protocol.player.ClientVersion;
import io.fairyproject.libs.packetevents.protocol.world.positionsource.PositionSource;
import io.fairyproject.libs.packetevents.protocol.world.positionsource.PositionSourceTypes;
import io.fairyproject.libs.packetevents.util.Vector3i;
import io.fairyproject.libs.packetevents.wrapper.PacketWrapper;

public class BlockPositionSource
extends PositionSource {
    private Vector3i pos;

    public BlockPositionSource(Vector3i pos) {
        super(PositionSourceTypes.BLOCK);
        this.pos = pos;
    }

    public static BlockPositionSource read(PacketWrapper<?> wrapper) {
        return new BlockPositionSource(wrapper.readBlockPosition());
    }

    public static void write(PacketWrapper<?> wrapper, BlockPositionSource source) {
        wrapper.writeBlockPosition(source.pos);
    }

    public static BlockPositionSource decodeSource(NBTCompound compound, ClientVersion version) {
        NBTIntArray arr = compound.getTagOfTypeOrThrow("pos", NBTIntArray.class);
        return new BlockPositionSource(new Vector3i(arr.getValue()));
    }

    public static void encodeSource(BlockPositionSource source, ClientVersion version, NBTCompound compound) {
        compound.setTag("pos", new NBTIntArray(new int[]{source.pos.x, source.pos.y, source.pos.z}));
    }

    public Vector3i getPos() {
        return this.pos;
    }

    public void setPos(Vector3i pos) {
        this.pos = pos;
    }
}

