/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.mc;

import io.fairyproject.libs.kyori.adventure.text.Component;
import io.fairyproject.libs.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import io.fairyproject.libs.kyori.adventure.text.serializer.gson.LegacyHoverEventSerializer;
import io.fairyproject.libs.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import io.fairyproject.libs.kyori.adventure.translation.GlobalTranslator;
import io.fairyproject.mc.MCServer;
import io.fairyproject.mc.version.MCVersion;
import io.fairyproject.mc.version.MCVersionMapping;
import io.fairyproject.mc.version.MCVersionMappingRegistry;
import java.util.Locale;

public final class MCAdventure {
    public static GsonComponentSerializer GSON;
    public static LegacyComponentSerializer LEGACY;

    public static void initialize(MCServer mcServer, MCVersionMappingRegistry mappingRegistry, AdventureHook adventureHook) {
        GsonComponentSerializer.Builder builder = GsonComponentSerializer.builder();
        LegacyComponentSerializer.Builder legacyBuilder = LegacyComponentSerializer.builder();
        MCVersion version = mcServer.getVersion();
        MCVersionMapping mapping = mappingRegistry.findMapping(version);
        if (!mapping.isHexColorSupport()) {
            builder.downsampleColors();
        }
        if (version.isHigherOrEqual(MCVersion.of(16))) {
            legacyBuilder.hexColors().useUnusualXRepeatedCharacterHexFormat();
            builder.legacyHoverEventSerializer(adventureHook.getSerializer());
        } else {
            legacyBuilder.character('\u00a7');
            builder.legacyHoverEventSerializer(adventureHook.getSerializer()).emitLegacyHoverEvent().downsampleColors();
        }
        GSON = builder.build();
        LEGACY = legacyBuilder.build();
    }

    public static String asJsonString(Component component, Locale locale) {
        return (String)GSON.serialize(GlobalTranslator.render(component, locale));
    }

    public static String asLegacyString(Component component, Locale locale) {
        return LEGACY.serialize(GlobalTranslator.render(component, locale));
    }

    public static String asItemString(Component component, Locale locale) {
        if (MCServer.current().getVersion().isHigherOrEqual(MCVersion.of(13))) {
            return MCAdventure.asJsonString(component, locale);
        }
        return MCAdventure.asLegacyString(component, locale);
    }

    private MCAdventure() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class AdventureHook {
        private LegacyHoverEventSerializer serializer;

        AdventureHook(LegacyHoverEventSerializer serializer) {
            this.serializer = serializer;
        }

        public static AdventureHookBuilder builder() {
            return new AdventureHookBuilder();
        }

        public LegacyHoverEventSerializer getSerializer() {
            return this.serializer;
        }

        public void setSerializer(LegacyHoverEventSerializer serializer) {
            this.serializer = serializer;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AdventureHook)) {
                return false;
            }
            AdventureHook other = (AdventureHook)o;
            if (!other.canEqual(this)) {
                return false;
            }
            LegacyHoverEventSerializer this$serializer = this.getSerializer();
            LegacyHoverEventSerializer other$serializer = other.getSerializer();
            return !(this$serializer == null ? other$serializer != null : !this$serializer.equals(other$serializer));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AdventureHook;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            LegacyHoverEventSerializer $serializer = this.getSerializer();
            result = result * 59 + ($serializer == null ? 43 : $serializer.hashCode());
            return result;
        }

        public String toString() {
            return "MCAdventure.AdventureHook(serializer=" + this.getSerializer() + ")";
        }

        public static class AdventureHookBuilder {
            private LegacyHoverEventSerializer serializer;

            AdventureHookBuilder() {
            }

            public AdventureHookBuilder serializer(LegacyHoverEventSerializer serializer) {
                this.serializer = serializer;
                return this;
            }

            public AdventureHook build() {
                return new AdventureHook(this.serializer);
            }

            public String toString() {
                return "MCAdventure.AdventureHook.AdventureHookBuilder(serializer=" + this.serializer + ")";
            }
        }
    }
}

