/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.mc.hologram.entity.impl;

import io.fairyproject.libs.packetevents.protocol.entity.data.EntityData;
import io.fairyproject.libs.packetevents.protocol.entity.data.EntityDataTypes;
import io.fairyproject.libs.packetevents.protocol.entity.type.EntityTypes;
import io.fairyproject.libs.packetevents.util.Vector3d;
import io.fairyproject.libs.packetevents.wrapper.play.server.WrapperPlayServerAttachEntity;
import io.fairyproject.libs.packetevents.wrapper.play.server.WrapperPlayServerDestroyEntities;
import io.fairyproject.libs.packetevents.wrapper.play.server.WrapperPlayServerEntityMetadata;
import io.fairyproject.libs.packetevents.wrapper.play.server.WrapperPlayServerEntityTeleport;
import io.fairyproject.libs.packetevents.wrapper.play.server.WrapperPlayServerSpawnEntity;
import io.fairyproject.libs.packetevents.wrapper.play.server.WrapperPlayServerSpawnLivingEntity;
import io.fairyproject.mc.MCAdventure;
import io.fairyproject.mc.MCEntity;
import io.fairyproject.mc.MCPlayer;
import io.fairyproject.mc.MCServer;
import io.fairyproject.mc.hologram.HologramImpl;
import io.fairyproject.mc.hologram.entity.impl.AbstractHologramEntity;
import io.fairyproject.mc.protocol.MCProtocol;
import io.fairyproject.mc.util.Position;
import io.fairyproject.mc.version.MCVersion;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class ArmorStandHologramEntity
extends AbstractHologramEntity {
    public ArmorStandHologramEntity(HologramImpl hologram) {
        super(hologram);
    }

    @Override
    public void show(@NotNull MCPlayer player) {
        Position pos = this.hologram.getPosition();
        if (MCServer.current().getVersion().isHigherOrEqual(MCVersion.of(1, 19))) {
            WrapperPlayServerSpawnEntity packet = new WrapperPlayServerSpawnEntity(this.entityId, Optional.of(this.entityUuid), EntityTypes.ARMOR_STAND, this.packetPosition(), pos.getPitch(), pos.getYaw(), pos.getYaw(), 0, Optional.of(new Vector3d()));
            MCProtocol.sendPacket(player, packet);
        } else {
            WrapperPlayServerSpawnLivingEntity packet = new WrapperPlayServerSpawnLivingEntity(this.entityId, this.entityUuid, EntityTypes.ARMOR_STAND, this.packetPosition(), pos.getYaw(), pos.getPitch(), 0.0f, new Vector3d(), this.createEntityData(player));
            MCProtocol.sendPacket(player, packet);
        }
        this.update(player);
    }

    @Override
    public void update(@NotNull MCPlayer player) {
        Position pos = this.hologram.getPosition();
        MCEntity attached = this.hologram.getAttached();
        WrapperPlayServerEntityMetadata metadataPacket = new WrapperPlayServerEntityMetadata(this.entityId, this.createEntityData(player));
        WrapperPlayServerEntityTeleport teleportPacket = new WrapperPlayServerEntityTeleport(this.entityId, this.packetPosition(), pos.getYaw(), pos.getPitch(), false);
        WrapperPlayServerAttachEntity attachEntityPacket = new WrapperPlayServerAttachEntity(this.entityId, attached != null ? attached.getId() : -1, false);
        MCProtocol.sendPacket(player, teleportPacket);
        MCProtocol.sendPacket(player, metadataPacket);
        MCProtocol.sendPacket(player, attachEntityPacket);
    }

    @Override
    public void hide(@NotNull MCPlayer player) {
        WrapperPlayServerDestroyEntities packet = new WrapperPlayServerDestroyEntities(this.entityId);
        MCProtocol.sendPacket(player, packet);
    }

    private List<EntityData<?>> createEntityData(MCPlayer player) {
        MCServer server = this.hologram.getServer();
        ArrayList entityDataList = new ArrayList();
        entityDataList.add(new EntityData<Byte>(0, EntityDataTypes.BYTE, (byte)32));
        MCVersion version = server.getVersion();
        if (version.isHigherOrEqual(MCVersion.of(13))) {
            entityDataList.add(new EntityData<Optional<String>>(2, EntityDataTypes.OPTIONAL_COMPONENT, Optional.ofNullable(this.line.render(player)).map(e -> MCAdventure.asItemString(e, player.getLocale()))));
        } else {
            entityDataList.add(new EntityData<String>(2, EntityDataTypes.STRING, MCAdventure.asLegacyString(this.line.render(player), player.getLocale())));
        }
        if (version.isHigherOrEqual(MCVersion.of(9))) {
            entityDataList.add(new EntityData<Boolean>(3, EntityDataTypes.BOOLEAN, true));
        } else {
            entityDataList.add(new EntityData<Byte>(3, EntityDataTypes.BYTE, (byte)1));
        }
        if (version.isHigherOrEqual(MCVersion.of(17))) {
            entityDataList.add(new EntityData<Byte>(15, EntityDataTypes.BYTE, (byte)17));
        } else if (version.isHigherOrEqual(MCVersion.of(15))) {
            entityDataList.add(new EntityData<Byte>(14, EntityDataTypes.BYTE, (byte)17));
        } else if (version.isHigherOrEqual(MCVersion.of(14))) {
            entityDataList.add(new EntityData<Byte>(13, EntityDataTypes.BYTE, (byte)17));
        } else if (version.isHigherOrEqual(MCVersion.of(10))) {
            entityDataList.add(new EntityData<Byte>(11, EntityDataTypes.BYTE, (byte)17));
        } else {
            entityDataList.add(new EntityData<Byte>(10, EntityDataTypes.BYTE, (byte)17));
        }
        return entityDataList;
    }
}

