/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.mc.protocol;

import io.fairyproject.util.exceptionally.ThrowingSupplier;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Function;

public class PacketEventsGithubResourceProvider
implements Function<String, InputStream> {
    private final String url = "https://raw.githubusercontent.com/retrooper/packetevents/2.0/api/src/main/resources/%s";
    private final Path cacheDirectory;

    @Override
    public InputStream apply(String s) {
        return ThrowingSupplier.sneaky(() -> {
            Path path = this.cacheDirectory.resolve(s);
            if (Files.exists(path, new LinkOption[0])) {
                return Files.newInputStream(path, new OpenOption[0]);
            }
            HttpURLConnection connection = (HttpURLConnection)new URL(String.format("https://raw.githubusercontent.com/retrooper/packetevents/2.0/api/src/main/resources/%s", s)).openConnection();
            connection.setRequestMethod("GET");
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            try (InputStream inputStream = connection.getInputStream();){
                byte[] bytes = this.readAllBytes(inputStream);
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.write(path, bytes, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
                return byteArrayInputStream;
            }
        }).get();
    }

    private byte[] readAllBytes(InputStream inputStream) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            output.write(buffer, 0, bytesRead);
        }
        return output.toByteArray();
    }

    public PacketEventsGithubResourceProvider(Path cacheDirectory) {
        this.cacheDirectory = cacheDirectory;
    }
}

