/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.mc.scheduler;

import io.fairyproject.mc.scheduler.MCScheduler;
import io.fairyproject.scheduler.ScheduledTask;
import io.fairyproject.scheduler.response.TaskResponse;
import java.time.Duration;
import java.util.concurrent.Callable;

public interface MCMillisBasedScheduler
extends MCScheduler {
    @Override
    default public ScheduledTask<?> schedule(Runnable runnable, long delayTicks) {
        return this.schedule(runnable, Duration.ofMillis(delayTicks * 50L));
    }

    @Override
    default public ScheduledTask<?> scheduleAtFixedRate(Runnable runnable, long delayTicks, long intervalTicks) {
        return this.scheduleAtFixedRate(runnable, Duration.ofMillis(delayTicks * 50L), Duration.ofMillis(intervalTicks * 50L));
    }

    @Override
    default public <R> ScheduledTask<R> schedule(Callable<R> callable, long delayTicks) {
        return this.schedule(callable, Duration.ofMillis(delayTicks * 50L));
    }

    @Override
    default public <R> ScheduledTask<R> scheduleAtFixedRate(Callable<TaskResponse<R>> callback, long delayTicks, long intervalTicks) {
        return this.scheduleAtFixedRate(callback, Duration.ofMillis(delayTicks * 50L), Duration.ofMillis(intervalTicks * 50L));
    }
}

