/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.plugin;

import io.fairyproject.library.Library;
import io.fairyproject.libs.gson.JsonElement;
import io.fairyproject.libs.gson.JsonObject;
import io.fairyproject.util.ConditionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class PluginDescription {
    private final String name;
    private final String mainClass;
    private final String shadedPackage;
    private final String fairyPackage;
    private final List<Library> libraries;

    public PluginDescription(JsonObject jsonObject) {
        ConditionUtils.is(jsonObject.has("name"), "name property could not be found.");
        ConditionUtils.is(jsonObject.has("mainClass"), "mainClass property could not be found.");
        ConditionUtils.is(jsonObject.has("shadedPackage"), "shadedPackage property could not be found.");
        this.name = jsonObject.get("name").getAsString();
        this.mainClass = jsonObject.get("mainClass").getAsString();
        this.shadedPackage = jsonObject.get("shadedPackage").getAsString();
        this.fairyPackage = jsonObject.has("fairyPackage") ? jsonObject.get("fairyPackage").getAsString() : this.shadedPackage + ".fairy";
        this.libraries = new ArrayList<Library>();
        if (jsonObject.has("libraries")) {
            for (JsonElement jsonElement : jsonObject.getAsJsonArray("libraries")) {
                this.libraries.add(Library.fromJsonObject(jsonElement.getAsJsonObject()));
            }
        }
    }

    public static PluginDescriptionBuilder builder() {
        return new PluginDescriptionBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public String getShadedPackage() {
        return this.shadedPackage;
    }

    public String getFairyPackage() {
        return this.fairyPackage;
    }

    public List<Library> getLibraries() {
        return this.libraries;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PluginDescription)) {
            return false;
        }
        PluginDescription other = (PluginDescription)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$mainClass = this.getMainClass();
        String other$mainClass = other.getMainClass();
        if (this$mainClass == null ? other$mainClass != null : !this$mainClass.equals(other$mainClass)) {
            return false;
        }
        String this$shadedPackage = this.getShadedPackage();
        String other$shadedPackage = other.getShadedPackage();
        if (this$shadedPackage == null ? other$shadedPackage != null : !this$shadedPackage.equals(other$shadedPackage)) {
            return false;
        }
        String this$fairyPackage = this.getFairyPackage();
        String other$fairyPackage = other.getFairyPackage();
        if (this$fairyPackage == null ? other$fairyPackage != null : !this$fairyPackage.equals(other$fairyPackage)) {
            return false;
        }
        List<Library> this$libraries = this.getLibraries();
        List<Library> other$libraries = other.getLibraries();
        return !(this$libraries == null ? other$libraries != null : !((Object)this$libraries).equals(other$libraries));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PluginDescription;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $mainClass = this.getMainClass();
        result = result * 59 + ($mainClass == null ? 43 : $mainClass.hashCode());
        String $shadedPackage = this.getShadedPackage();
        result = result * 59 + ($shadedPackage == null ? 43 : $shadedPackage.hashCode());
        String $fairyPackage = this.getFairyPackage();
        result = result * 59 + ($fairyPackage == null ? 43 : $fairyPackage.hashCode());
        List<Library> $libraries = this.getLibraries();
        result = result * 59 + ($libraries == null ? 43 : ((Object)$libraries).hashCode());
        return result;
    }

    public String toString() {
        return "PluginDescription(name=" + this.getName() + ", mainClass=" + this.getMainClass() + ", shadedPackage=" + this.getShadedPackage() + ", fairyPackage=" + this.getFairyPackage() + ", libraries=" + this.getLibraries() + ")";
    }

    public PluginDescription(String name, String mainClass, String shadedPackage, String fairyPackage, List<Library> libraries) {
        this.name = name;
        this.mainClass = mainClass;
        this.shadedPackage = shadedPackage;
        this.fairyPackage = fairyPackage;
        this.libraries = libraries;
    }

    public static class PluginDescriptionBuilder {
        private String name;
        private String mainClass;
        private String shadedPackage;
        private String fairyPackage;
        private ArrayList<Library> libraries;

        PluginDescriptionBuilder() {
        }

        public PluginDescriptionBuilder name(String name) {
            this.name = name;
            return this;
        }

        public PluginDescriptionBuilder mainClass(String mainClass) {
            this.mainClass = mainClass;
            return this;
        }

        public PluginDescriptionBuilder shadedPackage(String shadedPackage) {
            this.shadedPackage = shadedPackage;
            return this;
        }

        public PluginDescriptionBuilder fairyPackage(String fairyPackage) {
            this.fairyPackage = fairyPackage;
            return this;
        }

        public PluginDescriptionBuilder library(Library library) {
            if (this.libraries == null) {
                this.libraries = new ArrayList();
            }
            this.libraries.add(library);
            return this;
        }

        public PluginDescriptionBuilder libraries(Collection<? extends Library> libraries) {
            if (libraries == null) {
                throw new NullPointerException("libraries cannot be null");
            }
            if (this.libraries == null) {
                this.libraries = new ArrayList();
            }
            this.libraries.addAll(libraries);
            return this;
        }

        public PluginDescriptionBuilder clearLibraries() {
            if (this.libraries != null) {
                this.libraries.clear();
            }
            return this;
        }

        public PluginDescription build() {
            List<Library> libraries;
            switch (this.libraries == null ? 0 : this.libraries.size()) {
                case 0: {
                    libraries = Collections.emptyList();
                    break;
                }
                case 1: {
                    libraries = Collections.singletonList(this.libraries.get(0));
                    break;
                }
                default: {
                    libraries = Collections.unmodifiableList(new ArrayList<Library>(this.libraries));
                }
            }
            return new PluginDescription(this.name, this.mainClass, this.shadedPackage, this.fairyPackage, libraries);
        }

        public String toString() {
            return "PluginDescription.PluginDescriptionBuilder(name=" + this.name + ", mainClass=" + this.mainClass + ", shadedPackage=" + this.shadedPackage + ", fairyPackage=" + this.fairyPackage + ", libraries=" + this.libraries + ")";
        }
    }
}

