/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.scheduler.response;

import io.fairyproject.scheduler.TaskState;
import io.fairyproject.scheduler.response.ContinueTaskResponse;
import io.fairyproject.scheduler.response.FailureTaskResponse;
import io.fairyproject.scheduler.response.SuccessTaskResponse;
import org.jetbrains.annotations.Nullable;

public interface TaskResponse<R> {
    public static <R> TaskResponse<R> success(R result) {
        return new SuccessTaskResponse<R>(result);
    }

    public static <R> TaskResponse<R> failure(Throwable throwable) {
        return new FailureTaskResponse(throwable, throwable.getMessage());
    }

    public static <R> TaskResponse<R> failure(String errorMessage) {
        return new FailureTaskResponse(null, errorMessage);
    }

    public static <R> TaskResponse<R> failure(Throwable throwable, String errorMessage) {
        return new FailureTaskResponse(throwable, errorMessage);
    }

    public static <R> TaskResponse<R> continueTask() {
        return ContinueTaskResponse.INSTANCE;
    }

    public TaskState getState();

    @Nullable
    public Throwable getThrowable();

    @Nullable
    public String getErrorMessage();

    @Nullable
    public R getResult();
}

