/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.state.impl;

import io.fairyproject.state.Signal;
import io.fairyproject.state.State;
import io.fairyproject.state.StateMachine;
import io.fairyproject.state.StateMachineTransitionBuilder;
import io.fairyproject.state.Transition;
import io.fairyproject.state.TransitionBuilder;
import io.fairyproject.state.impl.TransitionBuilderImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class StateMachineTransitionBuilderImpl
extends TransitionBuilderImpl
implements StateMachineTransitionBuilder {
    private final Map<State, TransitionBuilderImpl> stateTransitions = new HashMap<State, TransitionBuilderImpl>();

    @Override
    @NotNull
    public TransitionBuilder on(@NotNull State state) {
        return this.stateTransitions.computeIfAbsent(state, s -> new TransitionBuilderImpl());
    }

    @Override
    @NotNull
    public StateMachineTransitionBuilder when(@NotNull Signal signal, @NotNull TransitionBuilder.TransitionHandle handle) {
        return (StateMachineTransitionBuilder)super.when(signal, handle);
    }

    @Override
    @NotNull
    public StateMachineTransitionBuilder when(@NotNull Signal signal, @NotNull Consumer<TransitionBuilder.TransitionHandle> handle) {
        return (StateMachineTransitionBuilder)super.when(signal, handle);
    }

    @Override
    @NotNull
    public StateMachineTransitionBuilder when(@NotNull Signal signal, @NotNull Runnable runnable) {
        return (StateMachineTransitionBuilder)super.when(signal, runnable);
    }

    @Override
    public Transition build(StateMachine stateMachine) {
        Transition transition = super.build(stateMachine);
        return signal -> {
            State state = stateMachine.getCurrentState();
            TransitionBuilderImpl builder = this.stateTransitions.get(state);
            if (builder != null) {
                Transition stateTransition = builder.build(stateMachine);
                stateTransition.handle(signal);
            }
            transition.handle(signal);
        };
    }
}

