/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.util.exceptionally;

import io.fairyproject.util.exceptionally.CheckedException;
import io.fairyproject.util.exceptionally.SneakyThrowUtil;
import java.util.Objects;
import java.util.function.BiConsumer;

@FunctionalInterface
public interface ThrowingBiConsumer<T1, T2, EX extends Exception> {
    public void accept(T1 var1, T2 var2) throws EX;

    default public BiConsumer<T1, T2> unchecked() {
        return ThrowingBiConsumer.unchecked(this);
    }

    public static <T, U> BiConsumer<T, U> unchecked(ThrowingBiConsumer<? super T, ? super U, ?> consumer) {
        Objects.requireNonNull(consumer);
        return (arg1, arg2) -> {
            try {
                consumer.accept((Object)arg1, (Object)arg2);
            }
            catch (Exception e) {
                throw new CheckedException(e);
            }
        };
    }

    public static <T, U> BiConsumer<T, U> sneaky(ThrowingBiConsumer<? super T, ? super U, ?> consumer) {
        Objects.requireNonNull(consumer);
        return (arg1, arg2) -> {
            try {
                consumer.accept((Object)arg1, (Object)arg2);
            }
            catch (Exception e) {
                SneakyThrowUtil.sneakyThrow(e);
            }
        };
    }
}

