/*
 * Decompiled with CFR 0.152.
 */
package io.fairyproject.util.exceptionally;

import io.fairyproject.util.exceptionally.CheckedException;
import io.fairyproject.util.exceptionally.SneakyThrowUtil;
import java.util.Objects;

@FunctionalInterface
public interface ThrowingRunnable<E extends Exception> {
    public void run() throws E;

    public static Runnable unchecked(ThrowingRunnable<?> runnable) {
        Objects.requireNonNull(runnable);
        return () -> {
            try {
                runnable.run();
            }
            catch (Exception e) {
                throw new CheckedException(e);
            }
        };
    }

    public static Runnable sneaky(ThrowingRunnable<?> runnable) {
        Objects.requireNonNull(runnable);
        return () -> {
            try {
                runnable.run();
            }
            catch (Exception e) {
                SneakyThrowUtil.sneakyThrow(e);
            }
        };
    }
}

